package com.sdk.wisetracker.base.tracker.network.interceptor;

import android.util.Log;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

/**
 * API 호출 후 응답 Raw-Data 확인 Interceptor
 */
public class RetrofitLogInterceptor implements Interceptor {

    private String tag;

    public RetrofitLogInterceptor(String tag) {
        this.tag = tag;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {

        try {

            Request request = chain.request();
            Response response = chain.proceed(request);
            String rawJson = response.body().string();
            WiseLog.d("SERVER RESPONSE -> " + rawJson);
            return response.newBuilder().body(ResponseBody.create(response.body().contentType(), rawJson)).build(); // Re-create the response before returning it because body can be read only once

        } catch (IOException e) {
            Log.e(tag, "retrofit io exception", e);
        } catch (Exception e) {
            Log.e(tag, "retrofit intercept error !!", e);
        }

        return chain.proceed(chain.request().newBuilder().build());

    }

}
