package com.sdk.wisetracker.base.open.model;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * 고객사 푸시 수신시 SDK 전달 모델 객체
 */
public class Push implements Parcelable {

    public String id = "";
    public String campaignId = "";
    public String title = "";
    public long expireTime = 0;

    public Push() {

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public static Creator<Push> getCREATOR() {
        return CREATOR;
    }

    protected Push(Parcel in) {
        id = in.readString();
        campaignId = in.readString();
        title = in.readString();
        expireTime = in.readLong();
    }

    public static final Creator<Push> CREATOR = new Creator<Push>() {

        @Override
        public Push createFromParcel(Parcel in) {
            return new Push(in);
        }

        @Override
        public Push[] newArray(int size) {
            return new Push[size];
        }

    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(id);
        dest.writeString(campaignId);
        dest.writeString(title);
        dest.writeLong(expireTime);
    }

}
