/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.network;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class BaseRetrofit<T> {
    private T api = null;
    private static final int TIME_OUT = 15;
    private HeaderType headerType = null;

    public abstract String getTag();

    public abstract String getUrl();

    public abstract Interceptor getHeaderInterceptor(HeaderType var1);

    public abstract Interceptor getLogInterceptor();

    public T getBaseApi(Class<T> targetClass, HeaderType headerType) {
        try {
            if (this.headerType == null || !this.headerType.equals((Object)headerType)) {
                Retrofit client = new Retrofit.Builder().baseUrl(this.getUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(new OkHttpClient().newBuilder().retryOnConnectionFailure(false).connectTimeout(15L, TimeUnit.SECONDS).addInterceptor(this.getHeaderInterceptor(headerType)).addInterceptor(this.getLogInterceptor()).build()).build();
                this.api = client.create(targetClass);
                this.headerType = headerType;
            }
            return this.api;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return null;
        }
    }
}

