/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.sdk.wisetracker.base.open.model.Push;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BaseDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.SessionRetrofit;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class PushDataManager
extends BaseDataManager {
    private static PushDataManager instance = null;

    public static PushDataManager getInstance() {
        if (instance == null) {
            instance = new PushDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
        this.setPushData();
    }

    @Override
    public void afterTransaction() {
        this.session.setPushTitle(null);
        this.session.setIsNewPushToken("N");
        super.afterTransaction();
    }

    private void setPushData() {
        long expireTime = this.session.getPushExpireTime();
        long clickTime = this.session.getPushClickTime();
        if (clickTime + 86400000L * expireTime <= System.currentTimeMillis()) {
            this.session.setPushId(null);
            this.session.setPushExpireTime(0L);
            this.session.setPushClickTime(0L);
        }
    }

    public void setPushClick(Intent intent) {
        try {
            if (intent == null) {
                WiseLog.d("intent is null");
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("push_sk")) || !TextUtils.isEmpty((CharSequence)intent.getStringExtra("MH_push_payload_NOTI_ID"))) {
                String id = intent.getStringExtra("push_sk");
                String campaignId = intent.getStringExtra("MH_push_payload_NOTI_ID");
                String title = intent.getStringExtra("MH_push_payload_TITLE");
                if (TextUtils.isEmpty((CharSequence)title)) {
                    String body = intent.getStringExtra("MH_push_payload_BODY");
                    title = body.substring(0, 128);
                    title = title.replaceAll("'", "");
                    title = title.replaceAll("\"", "");
                }
                String pushId = campaignId + "#" + id;
                this.session.setPushId(pushId);
                this.session.setPushTitle(title);
                this.session.setPushExpireTime(intent.getLongExtra("period", (long)this.session.getExpireDate()));
                this.session.setPushClickTime(System.currentTimeMillis());
            } else if (intent.getParcelableExtra(Push.class.getSimpleName()) != null) {
                Push push = (Push)intent.getParcelableExtra(Push.class.getSimpleName());
                String pushId = push.getCampaignId() + "#" + push.getId();
                this.session.setPushId(pushId);
                this.session.setPushTitle(push.getTitle());
                this.session.setPushExpireTime(push.getExpireTime() == 0L ? (long)this.session.getExpireDate() : push.getExpireTime());
                this.session.setPushClickTime(System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            WiseLog.e("set alarm link data error !! ", e);
        }
    }

    public void setPushReceiverId(Intent intent) {
        try {
            if (intent == null) {
                WiseLog.d("intent is null");
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("push_sk")) || !TextUtils.isEmpty((CharSequence)intent.getStringExtra("MH_push_payload_NOTI_ID"))) {
                String campaignID = intent.getStringExtra("MH_push_payload_NOTI_ID");
                String pushId = intent.getStringExtra("push_sk");
                String id = campaignID + "#" + pushId;
                this.sendPushId(id);
            } else if (intent.getParcelableExtra(Push.class.getSimpleName()) != null) {
                Push push = (Push)intent.getParcelableExtra(Push.class.getSimpleName());
                String id = push.getCampaignId() + "#" + push.getId();
                this.sendPushId(id);
            }
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void sendPushId(String id) {
        Session session = SessionDataManager.getInstance().getSession();
        String serviceNumber = String.valueOf(session.getServiceNumber());
        String adId = session.getAdId();
        String uuid = session.getUuid();
        SessionApi api = SessionRetrofit.getInstance().getBaseApi(SessionApi.class, HeaderType.DOT);
        api.sendReceivedPush(serviceNumber, adId, uuid, id, System.currentTimeMillis()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<JsonObject>(){

            public void accept(JsonObject jsonObject) {
                WiseLog.d("success");
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                WiseLog.e(throwable);
            }
        });
    }

    public void setPushToken(String token) {
        if (TextUtils.isEmpty((CharSequence)this.session.getPushToken())) {
            this.session.setIsNewPushToken("Y");
        } else if (!this.session.getPushToken().equals(token)) {
            this.session.setIsNewPushToken("Y");
        }
        this.session.setPushToken(token);
    }
}

