/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.common.log;

import android.text.TextUtils;
import android.util.Log;
import com.google.gson.GsonBuilder;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import org.json.JSONArray;
import org.json.JSONObject;

public class WiseValidation {
    public static boolean mIsDebug = false;
    private static final String DOT_VALIDATION_TAG = "DOT_VALIDATION";
    private static final String DOX_VALIDATION_TAG = "DOX_VALIDATION";

    public static void setIsDebug(boolean isDebug) {
        mIsDebug = isDebug;
    }

    public static void dotSdkValidation(String json) {
        try {
            if (!mIsDebug) {
                return;
            }
            JSONArray jsonArray = new JSONArray(json);
            if (jsonArray.length() < 1) {
                return;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject == null) {
                    return;
                }
                WiseValidation.dotSessionValidation(jsonObject);
                WiseValidation.dotEventValidation(jsonObject);
            }
        }
        catch (Exception e) {
            Log.e((String)DOT_VALIDATION_TAG, (String)"sdk validation error", (Throwable)e);
        }
    }

    private static void dotSessionValidation(JSONObject jsonObject) {
        try {
            String validationLog;
            String attributionTag;
            if (!jsonObject.has("SESSION") || jsonObject.getJSONObject("SESSION") == null) {
                return;
            }
            JSONObject sessionObject = jsonObject.getJSONObject("SESSION");
            String visitNew = (String)sessionObject.get("isVisitNew");
            int count = (Integer)sessionObject.get("ltvt");
            if (count > 1 || TextUtils.isEmpty((CharSequence)visitNew) || !visitNew.equalsIgnoreCase("Y")) {
                return;
            }
            String visitTag = "[first app open : true], ";
            String matSource = null;
            if (sessionObject.has("its")) {
                matSource = (String)sessionObject.get("its");
            }
            String matCampaign = null;
            if (sessionObject.has("itc")) {
                matCampaign = (String)sessionObject.get("itc");
            }
            if (TextUtils.isEmpty((CharSequence)matSource) && TextUtils.isEmpty((CharSequence)matCampaign)) {
                attributionTag = "[install : organic]";
                validationLog = "Install Type: organic install";
            } else {
                attributionTag = "[matSource : " + matSource + "],[matCampaign : " + matCampaign + "]";
                validationLog = "Install Type: Non-organic install";
            }
            WiseLog.d("SESSION: " + visitTag + attributionTag);
            Log.d((String)DOT_VALIDATION_TAG, (String)validationLog);
            if (!TextUtils.isEmpty((CharSequence)matSource) && !TextUtils.isEmpty((CharSequence)matCampaign)) {
                Log.d((String)DOT_VALIDATION_TAG, (String)("Campaign : " + matCampaign));
                Log.d((String)DOT_VALIDATION_TAG, (String)("Media : " + matSource));
            }
        }
        catch (Exception e) {
            Log.e((String)DOT_VALIDATION_TAG, (String)"session validation error", (Throwable)e);
        }
    }

    private static void dotEventValidation(JSONObject jsonObject) {
        try {
            if (jsonObject.has("PAGES")) {
                JSONObject pagesObject = jsonObject.getJSONObject("PAGES");
                String jsonString = pagesObject.toString();
                Log.d((String)DOT_VALIDATION_TAG, (String)("PAGES: " + jsonString));
            } else if (jsonObject.has("GOAL")) {
                JSONObject goalObject = jsonObject.getJSONObject("GOAL");
                String jsonString = goalObject.toString();
                Log.d((String)DOT_VALIDATION_TAG, (String)("GOAL: " + jsonString));
            } else if (jsonObject.has("CLICK")) {
                JSONObject clickObject = jsonObject.getJSONObject("CLICK");
                String jsonString = clickObject.toString();
                Log.d((String)DOT_VALIDATION_TAG, (String)("CLICK: " + jsonString));
            } else if (jsonObject.has("REVENUE")) {
                JSONObject revenueObject = jsonObject.getJSONObject("REVENUE");
                String jsonString = revenueObject.toString();
                Log.d((String)DOT_VALIDATION_TAG, (String)("REVENUE: " + jsonString));
            }
        }
        catch (Exception e) {
            Log.e((String)DOT_VALIDATION_TAG, (String)"event validation error", (Throwable)e);
        }
    }

    private static String getPrettyJson(String json) {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)json);
    }

    public static void doxSdkValidation(String json) {
        try {
            if (!mIsDebug) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)json)) {
                return;
            }
            JSONArray jsonArray = new JSONArray(json);
            if (jsonArray.length() < 1) {
                return;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (jsonArray.getJSONObject(i) == null) continue;
                WiseValidation.doxEventValidation(jsonArray.getJSONObject(i));
            }
        }
        catch (Exception e) {
            Log.e((String)DOX_VALIDATION_TAG, (String)"dox sdk validation error", (Throwable)e);
        }
    }

    private static void doxEventValidation(JSONObject jsonObject) {
        try {
            if (jsonObject.has("groupproperties")) {
                JSONObject groupProperties = jsonObject.getJSONObject("groupproperties");
                if (groupProperties == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d((String)DOX_VALIDATION_TAG, (String)("sequence : " + sequence + ", eventId : " + eventId));
                Log.d((String)DOX_VALIDATION_TAG, (String)("groupproperties : " + groupProperties.toString()));
            } else if (jsonObject.has("userproperties")) {
                JSONObject userProperties = jsonObject.getJSONObject("userproperties");
                if (userProperties == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d((String)DOX_VALIDATION_TAG, (String)("sequence : " + sequence + ", eventId : " + eventId));
                Log.d((String)DOX_VALIDATION_TAG, (String)("userproperties : " + userProperties.toString()));
            } else if (jsonObject.has("events")) {
                JSONObject events = jsonObject.getJSONObject("events");
                if (events == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d((String)DOX_VALIDATION_TAG, (String)("sequence : " + sequence + ", eventId : " + eventId));
                Log.d((String)DOX_VALIDATION_TAG, (String)("events : " + events.toString()));
            } else if (jsonObject.has("conversion")) {
                JSONObject conversion = jsonObject.getJSONObject("conversion");
                if (conversion == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d((String)DOX_VALIDATION_TAG, (String)("sequence : " + sequence + ", eventId : " + eventId));
                Log.d((String)DOX_VALIDATION_TAG, (String)("conversion : " + conversion.toString()));
            } else if (jsonObject.has("revenue")) {
                JSONObject revenue = jsonObject.getJSONObject("revenue");
                if (revenue == null) {
                    return;
                }
                int sequence = jsonObject.getInt("sequence");
                int eventId = jsonObject.getInt("eventId");
                Log.d((String)DOX_VALIDATION_TAG, (String)("sequence : " + sequence + ", eventId : " + eventId));
                Log.d((String)DOX_VALIDATION_TAG, (String)("revenue : " + revenue.toString()));
            }
        }
        catch (Exception e) {
            Log.e((String)DOX_VALIDATION_TAG, (String)"dox event validation error", (Throwable)e);
        }
    }
}

