package com.sdk.wisetracker.base.tracker.data.model;

import android.os.Build;
import android.text.TextUtils;

import com.google.gson.annotations.SerializedName;
import com.sdk.wisetracker.base.BuildConfig;

import java.util.Map;

/**
 * Session 데이터 정의 모델 class
 */
public class Session {

    // visit
    private @SerializedName("udVt") int userCriteriaVisit = 0;
    private @SerializedName("ltvt") int lifeCriteriaVisit = 0;           // session 카운트
    private @SerializedName("ltVi") int lifeVisitInterval = 0;
    private @SerializedName("isVisitNew") String visitNew = null;
    private @SerializedName("sid") String sessionId = null;
    private @SerializedName("isDf") String dailyUnique = null;
    private @SerializedName("isWf") String weeklyUnique = null;
    private @SerializedName("isWfUs") String weeklyUnique2 = null;
    private @SerializedName("isMf") String monthlyUnique = null;
    private @SerializedName("installTime") long installTime = 0;

    // purchase event
    private @SerializedName("ltRvnVt") int spendingVisitToPurchase = 0;
    private @SerializedName("udRvnc") int userCriteriaPurchase = 0;
    private @SerializedName("ltRvnc") int lifeCriteriaPurchase = 0;      // 누적 주문수
    private @SerializedName("ltrvn") long lifePurchaseAmount = 0;            // 누적 매출액
    private @SerializedName("ltrvni") int lifePurchaseInterval = 0;      // 누적 주문전환 간격
    private @SerializedName("csRvnVs") long spendingTimeToPurchase = 0;      // 주문전환 소요시간
    private @SerializedName("firstOrd") String firstPurchase = "N";
    private @SerializedName("lastOrdNo") String lastOrderNumber = null;

    // page event
    private @SerializedName("piTrace") String piTrace = null;
    private @SerializedName("isSearchFail") String searchFail = null;
    private @SerializedName("pageKey") int pageKey = 0;

    // push
    private @SerializedName("pushNo") String pushId = null;
    private @SerializedName("pushTitle") String pushTitle = null;
    private @SerializedName("pushCkTime") long pushClickTime = 0;
    private @SerializedName("pushPeriod") long pushExpireTime = 0;

    // app key
    private @SerializedName("useMode") String useMode = null;
    private @SerializedName("_accessToken") String accessToken = null;
    private @SerializedName("_wthst") String domain = null;
    private @SerializedName("_wtno") int serviceNumber = 0;
    private @SerializedName("_wtUdays") int expireDate = 0;
    private @SerializedName("_wtDebug") boolean isDebug = false;
    private @SerializedName("_wtUseRetention") boolean isInstallRetention = false;
    private @SerializedName("_wtUseFingerPrint") boolean isFingerPrint = false;
    private @SerializedName("domain_x") String domainX= null;

    // environment
    private @SerializedName("lng") String language = null;
    private @SerializedName("cntr") String country = null;
    private @SerializedName("tz") String timeZone = null;
    private @SerializedName("os") String os = null;
    private @SerializedName("sr") String resolution = null;
    private @SerializedName("phone") String deviceModel = null;
    private @SerializedName("apVr") String appVersion = null;
    private @SerializedName("gps") String gps = null;
    private @SerializedName("cari") String carriers = "";
    private @SerializedName("isWifi") int networkType = 0;
    private @SerializedName("inch") double inch = 0;
    private @SerializedName("uuid") String uuid = null;
    private @SerializedName("device_uuid") String deviceUuid = null;
    private @SerializedName("vendor_id") String vendorId = null;
    private @SerializedName("advtId") String adId = null;
    private @SerializedName("advtFlag") int adFlag = 0; // 0. 광고허용 1.광고차단
    private @SerializedName("aidChange") String adIdChange = null;
    private @SerializedName("buildMode") String buildMode = BuildConfig.BUILD_TYPE.equals("debug") ? "dev" : "prod";
    private @SerializedName("pushtk") String pushToken = null;
    private @SerializedName("saveToken") String isNewPushToken = "N";
    private @SerializedName("plat") String platform = "AOS";
    private @SerializedName("open_platform") String openPlatform = "Native";
    private @SerializedName("dSource") String sdk = "SDK";
    private @SerializedName("sdk_version") Map<String, String> sdkVersion = null;
    private @SerializedName("pkg") String packageName = null;
    private @SerializedName("osvr") String releaseVersion = Build.VERSION.RELEASE;
    private @SerializedName("irCompleteTime") long appInstallTime = 0;
    private @SerializedName("appUpdateTime") long appUpdateTime = 0;

    // deep link
    private @SerializedName("int_ref") String deepLinkReferrer = null;
    private @SerializedName("wts") String adSource = null;
    private @SerializedName("wtm") String adType = null;
    private @SerializedName("wtc") String adCampaign = null;
    private @SerializedName("wtw") String adKeyword = null;
    private @SerializedName("wtclkTime") long adClickTime = 0;
    private @SerializedName("wtp") int adExpireDay = 0;
    private @SerializedName("wtref") String adLinkUrl = null;
    private @SerializedName("wtaffid") String depth1 = null;
    private @SerializedName("wtbffid") String depth2 = null;
    private @SerializedName("isDrUpdate") String isDeepLinkUpdate = null;
    private @SerializedName("latestGcmpid") String googleCampaignId = null;
    private @SerializedName("openDl") String openDeepLink = null;

    // install referrer
    private @SerializedName("its") String adInstallSource = null;
    private @SerializedName("itm") String adInstallType = null;
    private @SerializedName("itc") String adInstallCampaign = null;
    private @SerializedName("itw") String adInstallKeyword = null;
    private @SerializedName("itclkTime") long adInstallClickTime = 0;
    private @SerializedName("itp") int adInstallExpireTime = 0;
    private @SerializedName("installReferrer") String installReferrer = null;
    private @SerializedName("itaffid") String installDepth1 = null;
    private @SerializedName("itbffid") String installDepth2 = null;
    private @SerializedName("isIrUpdate") String isReferrerUpdate = null;
    private @SerializedName("irBeginTime") long beginTime = 0;
    private @SerializedName("mktVisitTime") long clickTime = 0;
    private String clickId = null;

    // user info
    private @SerializedName("isLogin") boolean isLogin = false;
    private @SerializedName("mbr") String member = null;
    private @SerializedName("mbl") String memberGrade = null;
    private @SerializedName("mbid") String memberId = null;
    private @SerializedName("sx") String gender = null;
    private @SerializedName("ag") String age = null;
    private @SerializedName("ut1") String attribute1 = null;
    private @SerializedName("ut2") String attribute2 = null;
    private @SerializedName("ut3") String attribute3 = null;
    private @SerializedName("ut4") String attribute4 = null;
    private @SerializedName("ut5") String attribute5 = null;
    private @SerializedName("userId") String userId = null;
    private @SerializedName("loginTp") String loginTp = null;
    private @SerializedName("signupTp") String signupTp = null;

    public int getUserCriteriaVisit() {
        return userCriteriaVisit;
    }

    public void setUserCriteriaVisit(int userCriteriaVisit) {
        this.userCriteriaVisit = userCriteriaVisit;
    }

    public int getLifeCriteriaVisit() {
        return lifeCriteriaVisit;
    }

    public void setLifeCriteriaVisit(int lifeCriteriaVisit) {
        this.lifeCriteriaVisit = lifeCriteriaVisit;
    }

    public int getLifeVisitInterval() {
        return lifeVisitInterval;
    }

    public void setLifeVisitInterval(int lifeVisitInterval) {
        this.lifeVisitInterval = lifeVisitInterval;
    }

    public String getVisitNew() {
        return visitNew;
    }

    public void setVisitNew(String visitNew) {
        this.visitNew = visitNew;
    }

    public String getSessionId() {
        return sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getDailyUnique() {
        return dailyUnique;
    }

    public void setDailyUnique(String dailyUnique) {
        this.dailyUnique = dailyUnique;
    }

    public String getWeeklyUnique() {
        return weeklyUnique;
    }

    public void setWeeklyUnique(String weeklyUnique) {
        this.weeklyUnique = weeklyUnique;
    }

    public String getWeeklyUnique2() {
        return weeklyUnique2;
    }

    public void setWeeklyUnique2(String weeklyUnique2) {
        this.weeklyUnique2 = weeklyUnique2;
    }

    public String getMonthlyUnique() {
        return monthlyUnique;
    }

    public void setMonthlyUnique(String monthlyUnique) {
        this.monthlyUnique = monthlyUnique;
    }

    public int getSpendingVisitToPurchase() {
        return spendingVisitToPurchase;
    }

    public void setSpendingVisitToPurchase(int spendingVisitToPurchase) {
        this.spendingVisitToPurchase = spendingVisitToPurchase;
    }

    public int getUserCriteriaPurchase() {
        return userCriteriaPurchase;
    }

    public void setUserCriteriaPurchase(int userCriteriaPurchase) {
        this.userCriteriaPurchase = userCriteriaPurchase;
    }

    public int getLifeCriteriaPurchase() {
        return lifeCriteriaPurchase;
    }

    public void setLifeCriteriaPurchase(int lifeCriteriaPurchase) {
        this.lifeCriteriaPurchase = lifeCriteriaPurchase;
    }

    public long getLifePurchaseAmount() {
        return lifePurchaseAmount;
    }

    public void setLifePurchaseAmount(long lifePurchaseAmount) {
        this.lifePurchaseAmount = lifePurchaseAmount;
    }

    public int getLifePurchaseInterval() {
        return lifePurchaseInterval;
    }

    public void setLifePurchaseInterval(int lifePurchaseInterval) {
        this.lifePurchaseInterval = lifePurchaseInterval;
    }

    public long getSpendingTimeToPurchase() {
        return spendingTimeToPurchase;
    }

    public void setSpendingTimeToPurchase(long spendingTimeToPurchase) {
        this.spendingTimeToPurchase = spendingTimeToPurchase;
    }

    public String getFirstPurchase() {
        return firstPurchase;
    }

    public void setFirstPurchase(String firstPurchase) {
        this.firstPurchase = firstPurchase;
    }

    public String getLastOrderNumber() {
        return lastOrderNumber;
    }

    public void setLastOrderNumber(String lastOrderNumber) {
        if (TextUtils.isEmpty(lastOrderNumber)) {
            lastOrderNumber = "";
        }
        this.lastOrderNumber = lastOrderNumber;
    }

    public String getPiTrace() {
        return piTrace;
    }

    public void setPiTrace(String piTrace) {
        this.piTrace = piTrace;
    }

    public String getSearchFail() {
        return searchFail;
    }

    public void setSearchFail(String searchFail) {
        this.searchFail = searchFail;
    }

    public String getPushId() {
        return pushId;
    }

    public void setPushId(String pushId) {
        this.pushId = pushId;
    }

    public String getPushTitle() {
        return pushTitle;
    }

    public void setPushTitle(String pushTitle) {
        this.pushTitle = pushTitle;
    }

    public long getPushClickTime() {
        return pushClickTime;
    }

    public void setPushClickTime(long pushClickTime) {
        this.pushClickTime = pushClickTime;
    }

    public String getClickId() {
        return clickId;
    }

    public void setClickId(String clickId) {
        this.clickId = clickId;
    }

    public long getPushExpireTime() {
        return pushExpireTime;
    }

    public void setPushExpireTime(long pushExpireTime) {
        this.pushExpireTime = pushExpireTime;
    }

    public String getUseMode() {
        return useMode;
    }

    public void setUseMode(String useMode) {
        this.useMode = useMode;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public int getServiceNumber() {
        return serviceNumber;
    }

    public void setServiceNumber(int serviceNumber) {
        this.serviceNumber = serviceNumber;
    }

    public int getExpireDate() {
        return expireDate;
    }

    public void setExpireDate(int expireDate) {
        this.expireDate = expireDate;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public void setDebug(boolean debug) {
        isDebug = debug;
    }

    public boolean isInstallRetention() {
        return isInstallRetention;
    }

    public void setInstallRetention(boolean installRetention) {
        isInstallRetention = installRetention;
    }

    public boolean isFingerPrint() {
        return isFingerPrint;
    }

    public void setFingerPrint(boolean fingerPrint) {
        isFingerPrint = fingerPrint;
    }

    public String getDomainX() {
        return domainX;
    }

    public void setDomainX(String domainX) {
        this.domainX = domainX;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getTimeZone() {
        return timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getAppVersion() {
        return appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getGps() {
        return gps;
    }

    public void setGps(String gps) {
        this.gps = gps;
    }

    public String getCarriers() {
        return carriers;
    }

    public void setCarriers(String carriers) {
        this.carriers = carriers;
    }

    public int getNetworkType() {
        return networkType;
    }

    public void setNetworkType(int networkType) {
        this.networkType = networkType;
    }

    public double getInch() {
        return inch;
    }

    public void setInch(double inch) {
        this.inch = inch;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getDeviceUuid() {
        return deviceUuid;
    }

    public void setDeviceUuid(String deviceUuid) {
        this.deviceUuid = deviceUuid;
    }

    public String getVendorId() {
        return vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public String getAdId() {
        return adId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public int getAdFlag() {
        return adFlag;
    }

    public void setAdFlag(int adFlag) {
        this.adFlag = adFlag;
    }

    public String getAdIdChange() {
        return adIdChange;
    }

    public void setAdIdChange(String adIdChange) {
        this.adIdChange = adIdChange;
    }

    public String getBuildMode() {
        return buildMode;
    }

    public void setBuildMode(String buildMode) {
        this.buildMode = buildMode;
    }

    public String getPushToken() {
        return pushToken;
    }

    public void setPushToken(String pushToken) {
        this.pushToken = pushToken;
    }

    public void setIsNewPushToken(String isNewPushToken) {
        this.isNewPushToken = isNewPushToken;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getOpenPlatform() {
        return openPlatform;
    }

    public void setOpenPlatform(String openPlatform) {
        this.openPlatform = openPlatform;
    }

    public String getSdk() {
        return sdk;
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
    }

    public Map<String, String> getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(Map<String, String> sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getReleaseVersion() {
        return releaseVersion;
    }

    public void setReleaseVersion(String releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public long getAppInstallTime() {
        return appInstallTime;
    }

    public void setAppInstallTime(long appInstallTime) {
        this.appInstallTime = appInstallTime;
        this.installTime = appInstallTime;
    }

    public long getAppUpdateTime() {
        return appUpdateTime;
    }

    public void setAppUpdateTime(long appUpdateTime) {
        this.appUpdateTime = appUpdateTime;
    }

    public String getDeepLinkReferrer() {
        return deepLinkReferrer;
    }

    public void setDeepLinkReferrer(String deepLinkReferrer) {
        this.deepLinkReferrer = deepLinkReferrer;
    }

    public String getAdSource() {
        return adSource;
    }

    public void setAdSource(String adSource) {
        this.adSource = adSource;
    }

    public String getAdType() {
        return adType;
    }

    public void setAdType(String adType) {
        this.adType = adType;
    }

    public String getAdCampaign() {
        return adCampaign;
    }

    public void setAdCampaign(String adCampaign) {
        this.adCampaign = adCampaign;
    }

    public String getAdKeyword() {
        return adKeyword;
    }

    public void setAdKeyword(String adKeyword) {
        this.adKeyword = adKeyword;
    }

    public long getAdClickTime() {
        return adClickTime;
    }

    public void setAdClickTime(long adClickTime) {
        this.adClickTime = adClickTime;
    }

    public int getAdExpireDay() {
        return adExpireDay;
    }

    public void setAdExpireDay(int adExpireDay) {
        this.adExpireDay = adExpireDay;
    }

    public String getAdLinkUrl() {
        return adLinkUrl;
    }

    public void setAdLinkUrl(String adLinkUrl) {
        this.adLinkUrl = adLinkUrl;
    }

    public String getDepth1() {
        return depth1;
    }

    public void setDepth1(String depth1) {
        this.depth1 = depth1;
    }

    public String getDepth2() {
        return depth2;
    }

    public void setDepth2(String depth2) {
        this.depth2 = depth2;
    }

    public String getIsDeepLinkUpdate() {
        return isDeepLinkUpdate;
    }

    public void setIsDeepLinkUpdate(String isDeepLinkUpdate) {
        this.isDeepLinkUpdate = isDeepLinkUpdate;
    }

    public String getGoogleCampaignId() {
        return googleCampaignId;
    }

    public void setGoogleCampaignId(String googleCampaignId) {
        this.googleCampaignId = googleCampaignId;
    }

    public void setOpenDeepLink(String openDeepLink) {
        this.openDeepLink = openDeepLink;
    }

    public String getAdInstallSource() {
        return adInstallSource;
    }

    public void setAdInstallSource(String adInstallSource) {
        this.adInstallSource = adInstallSource;
    }

    public String getAdInstallType() {
        return adInstallType;
    }

    public void setAdInstallType(String adInstallType) {
        this.adInstallType = adInstallType;
    }

    public String getAdInstallCampaign() {
        return adInstallCampaign;
    }

    public void setAdInstallCampaign(String adInstallCampaign) {
        this.adInstallCampaign = adInstallCampaign;
    }

    public String getAdInstallKeyword() {
        return adInstallKeyword;
    }

    public void setAdInstallKeyword(String adInstallKeyword) {
        this.adInstallKeyword = adInstallKeyword;
    }

    public long getAdInstallClickTime() {
        return adInstallClickTime;
    }

    public void setAdInstallClickTime(long adInstallClickTime) {
        this.adInstallClickTime = adInstallClickTime;
    }

    public int getAdInstallExpireTime() {
        return adInstallExpireTime;
    }

    public void setAdInstallExpireTime(int adInstallExpireTime) {
        this.adInstallExpireTime = adInstallExpireTime;
    }

    public String getInstallReferrer() {
        return installReferrer;
    }

    public void setInstallReferrer(String installReferrer) {
        this.installReferrer = installReferrer;
    }

    public String getInstallDepth1() {
        return installDepth1;
    }

    public void setInstallDepth1(String installDepth1) {
        this.installDepth1 = installDepth1;
    }

    public String getInstallDepth2() {
        return installDepth2;
    }

    public void setInstallDepth2(String installDepth2) {
        this.installDepth2 = installDepth2;
    }

    public String getIsReferrerUpdate() {
        return isReferrerUpdate;
    }

    public void setIsReferrerUpdate(String isReferrerUpdate) {
        this.isReferrerUpdate = isReferrerUpdate;
    }

    public long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getClickTime() {
        return clickTime;
    }

    public void setClickTime(long clickTime) {
        this.clickTime = clickTime;
    }

    public boolean isLogin() {
        return isLogin;
    }

    public void setLogin(boolean login) {
        isLogin = login;
    }

    public String getMember() {
        return member;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public String getMemberGrade() {
        return memberGrade;
    }

    public void setMemberGrade(String memberGrade) {
        this.memberGrade = memberGrade;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getAge() {
        return age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoginTp() {
        return loginTp;
    }

    public void setLoginTp(String loginTp) {
        this.loginTp = loginTp;
    }

    public String getSignupTp() {
        return signupTp;
    }

    public void setSignupTp(String signupTp) {
        this.signupTp = signupTp;
    }

    public int getPageKey() {
        return pageKey;
    }

    public void setPageKey(int pageKey) {
        this.pageKey = pageKey;
    }
}
