/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.sdk.wisetracker.base.R;
import com.sdk.wisetracker.base.tracker.common.exception.InitializeAppKey2Exception;
import com.sdk.wisetracker.base.tracker.common.exception.InitializeAppKeyException;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.common.log.WiseValidation;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InitAppKey {
    private final String TAG = "InitAppKey";
    private static InitAppKey instance = null;

    public static InitAppKey getInstance() {
        if (instance == null) {
            instance = new InitAppKey();
        }
        return instance;
    }

    private List<CharSequence> getAppKeyList(Context context) {
        try {
            ArrayList<CharSequence> appKeyList = new ArrayList<CharSequence>(Arrays.asList(context.getResources().getTextArray(R.array.dotAuthorizationKey)));
            if (appKeyList == null || appKeyList.isEmpty()) {
                throw new InitializeAppKeyException();
            }
            return appKeyList;
        }
        catch (NoClassDefFoundError e) {
            this.authKeyExceptionHandling(context);
        }
        catch (InitializeAppKeyException e) {
            Log.d((String)"InitAppKey", (String)"check your app key");
            Log.d((String)"InitAppKey", (String)"check Strings.xml 'useMode'");
            Log.e((String)"InitAppKey", (String)"init app key  exception", (Throwable)e);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return null;
    }

    public void setAppKey(Context context) {
        List<CharSequence> appKeyList = this.getAppKeyList(context);
        if (appKeyList == null || appKeyList.isEmpty()) {
            return;
        }
        String useMode = appKeyList.get(0).toString();
        if (TextUtils.isEmpty((CharSequence)useMode)) {
            return;
        }
        if (useMode.equals("1") || useMode.equals("2")) {
            this.setDOTAppKey(appKeyList);
        } else if (useMode.equals("3")) {
            this.setDOXAppKey(appKeyList);
        }
    }

    private void setDOTAppKey(List<CharSequence> appKeyList) {
        if (appKeyList.size() < 8) {
            return;
        }
        Session session = SessionDataManager.getInstance().getSession();
        session.setUseMode(appKeyList.get(0).toString());
        session.setDomain(appKeyList.get(1).toString());
        session.setServiceNumber(Integer.valueOf(appKeyList.get(2).toString()));
        session.setExpireDate(Integer.valueOf(appKeyList.get(3).toString()));
        session.setDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        WiseValidation.setIsDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        session.setInstallRetention(Boolean.valueOf(appKeyList.get(5).toString()));
        session.setFingerPrint(Boolean.valueOf(appKeyList.get(6).toString()));
        session.setAccessToken(appKeyList.get(7).toString());
        if (appKeyList.size() == 9) {
            session.setDomainX(appKeyList.get(8).toString());
        }
        SessionDataManager.getInstance().saveSession(session);
    }

    private void setDOXAppKey(List<CharSequence> appKeyList) {
        Session session = SessionDataManager.getInstance().getSession();
        session.setUseMode(appKeyList.get(0).toString());
        session.setDomain(appKeyList.get(1).toString());
        session.setServiceNumber(Integer.valueOf(appKeyList.get(2).toString()));
        session.setExpireDate(Integer.valueOf(appKeyList.get(3).toString()));
        session.setDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        WiseValidation.setIsDebug(Boolean.valueOf(appKeyList.get(4).toString()));
        session.setInstallRetention(Boolean.valueOf(appKeyList.get(5).toString()));
        session.setFingerPrint(Boolean.valueOf(appKeyList.get(6).toString()));
        session.setAccessToken(appKeyList.get(7).toString());
        session.setDomainX(appKeyList.get(8).toString());
        SessionDataManager.getInstance().saveSession(session);
    }

    private void authKeyExceptionHandling(Context context) {
        try {
            WiseLog.d("auth key exception handling for unity");
            String useMode = null;
            ArrayList<CharSequence> appKeyList = new ArrayList<CharSequence>();
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = appInfo.metaData;
            if (bundle.containsKey("useMode")) {
                useMode = String.valueOf(bundle.getInt("useMode"));
            }
            if (TextUtils.isEmpty(useMode)) {
                Log.d((String)"InitAppKey", (String)"check your app key");
                Log.d((String)"InitAppKey", (String)"check AndroidManifest.xml 'useMode'");
                Log.e((String)"InitAppKey", (String)"init app key  exception", (Throwable)new InitializeAppKey2Exception());
                return;
            }
            appKeyList.add(useMode);
            if (bundle.containsKey("domain")) {
                appKeyList.add(bundle.getString("domain"));
            }
            if (bundle.containsKey("serviceNumber")) {
                appKeyList.add(String.valueOf(bundle.getInt("serviceNumber")));
            }
            if (bundle.containsKey("expireDate")) {
                appKeyList.add(String.valueOf(bundle.getInt("expireDate")));
            }
            if (bundle.containsKey("isDebug")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isDebug")));
            }
            if (bundle.containsKey("isInstallRetention")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isInstallRetention")));
            }
            if (bundle.containsKey("isFingerPrint")) {
                appKeyList.add(String.valueOf(bundle.getBoolean("isFingerPrint")));
            }
            if (bundle.containsKey("accessToken")) {
                appKeyList.add(bundle.getString("accessToken"));
            }
            if (bundle.containsKey("domain_x")) {
                appKeyList.add(bundle.getString("domain_x"));
            }
            this.setDOTAppKey(appKeyList);
        }
        catch (Exception e) {
            WiseLog.e("auth key exceptionHandling error", e);
        }
    }
}

