package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;

import com.android.installreferrer.api.ReferrerDetails;
import com.google.gson.Gson;
import com.sdk.wisetracker.base.open.model.User;
import com.sdk.wisetracker.base.tracker.common.WisetrackerDatabase;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.model.Session;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import io.reactivex.subjects.PublishSubject;

/**
 * 세션 데이터 관리 매니져
 */
public class SessionDataManager {

    private Session session;
    private List<BaseDataManager> dataManagerList;
    private static SessionDataManager instance = null;
    public static PublishSubject<Boolean> deepLinkSubject = PublishSubject.create();

    public static SessionDataManager getInstance() {
        if (instance == null) {
            instance = new SessionDataManager();
        }
        return instance;
    }

     // 저장된 세션 정보 획득
    public SessionDataManager() {
        String jsonString = WisetrackerDatabase.getStringValue(Session.class.getSimpleName());
        if (TextUtils.isEmpty(jsonString)) {
            session = new Session();
        } else {
            session = new Gson().fromJson(jsonString, Session.class);
            if (session == null) {
                session = new Session();
            }
            resetSession();
        }
        WiseLog.d("session data : " + new Gson().toJson(session));
    }

    private void resetSession() {
        // 저장 불필요 데이터 초기화
        session.setPiTrace(null);
        session.setSearchFail(null);
    }

    public void saveSession(Session session) {
        String jsonString = new Gson().toJson(session);
        WisetrackerDatabase.setDatabase(Session.class.getSimpleName(), jsonString);
    }

    public Session getSession() {
        return session;
    }

    // 세션 데이터 관린 매니져 class 등록
    public List<BaseDataManager> getDataManagerList() {
        if (dataManagerList == null) {
            dataManagerList = new ArrayList<>();
            dataManagerList.add(DeepLinkDataManager.getInstance());
            dataManagerList.add(InstallReferrerDataManager.getInstance());
            dataManagerList.add(PushDataManager.getInstance());
            dataManagerList.add(VisitDataManager.getInstance());
        }
        return dataManagerList;
    }

    public void setSdkVersion(Pair<String, String> pair) {
        Map<String, String> sdkVersionMap = session.getSdkVersion();
        if (sdkVersionMap == null) {
            return;
        }
        sdkVersionMap.put(pair.first, pair.second);
        session.setSdkVersion(sdkVersionMap);
    }

    public void setOpenPlatform(String openPlatform) {
        session.setOpenPlatform(openPlatform);
    }

    public Session getUpdateSessionData() {
        for (BaseDataManager manager : getDataManagerList()) {
            manager.setData();
        }
        return getSession();
    }

    public void updateSessionAfterTransaction() {
        for (BaseDataManager manager : getDataManagerList()) {
            manager.afterTransaction();
        }
    }

    public void setPushClick(Intent intent) {
        PushDataManager.getInstance().setPushClick(intent);
    }

    public void setPushToken(String pushToken) {
        PushDataManager.getInstance().setPushToken(pushToken);
    }

    public void setPushReceiver(Intent intent) {
        PushDataManager.getInstance().setPushReceiverId(intent);
    }

    public void setDeepLink(Intent intent) {
        DeepLinkDataManager.getInstance().openDeepLink(intent);
    }

    public void setDeepLink(String url) {
        DeepLinkDataManager.getInstance().openDeepLink(url);
    }

    public void setInstallReferrer(ReferrerDetails referrerDetails) {
        InstallReferrerDataManager.getInstance().checkInstallReferrer(referrerDetails);
    }

    public void setFacebookReferrer(Bundle bundle) {
        InstallReferrerDataManager.getInstance().setFacebookReferrer(bundle);
    }

    public void setUser(User user) {
        UserDataManager.getInstance().setUser(user);
    }

    public void setUserLogout() {
        UserDataManager.getInstance().setUserLogout();
    }

    public void setUserId(String userId) {
        UserDataManager.getInstance().setUserId(userId);
    }

    public void onPageEvent(String searchFail, String piTraceString) {
        VisitDataManager.getInstance().onPageEvent(searchFail, piTraceString);
    }

    public void onPurchaseEvent(long lifePurchaseAmount, String orderNumber) {
        VisitDataManager.getInstance().onPurchaseEvent(lifePurchaseAmount, orderNumber);
    }

//    public void setCookie() {
//        SessionManager.getInstance().setCookie();
//    }
//
//    public void setCookieTimeStamp(long timeStamp) {
//        SessionManager.getInstance().setCookieTimeStamp(timeStamp);
//    }

}
