package com.sdk.wisetracker.base.tracker.data.manager;

import android.util.Base64;
import android.webkit.WebView;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.io.InputStream;

/**
 * 웹뷰 이용시 SDK .js 파일 inject class
 */
public class WebViewManager {

    public void injectJavascript(WebView webView) {

        try {

            if (webView == null || webView.getContext() == null) {
                WiseLog.d("web view or context is null");
                return;
            }

            InputStream input = webView.getContext().getAssets().open("dop-native-sdk-inf.js");
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            input.close();
            String encoded = Base64.encodeToString(buffer, Base64.NO_WRAP);
            String injectJavascript = "javascript:(function() {" +
                    "var parent = document.getElementsByTagName('head').item(0);" +
                    "var script = document.createElement('script');" +
                    "script.type = 'text/javascript';" +
                    // Tell the browser to BASE64-decode the string into your script !!!
                    "script.innerHTML = window.atob('" + encoded + "');" +
                    "parent.appendChild(script)" +
                    "})()";
            webView.loadUrl(injectJavascript);

        } catch (Exception e) {
            WiseLog.e(e);
        }

    }

}
