package com.sdk.wisetracker.base.tracker.data.manager;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import com.android.installreferrer.api.ReferrerDetails;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.model.Const;
import com.sdk.wisetracker.base.tracker.util.TimeUtil;
import com.sdk.wisetracker.base.tracker.util.ValueOf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * 인스톨 레퍼러 값 유효성 체크 및 저장 class
 */
public class InstallReferrerDataManager extends BaseDataManager {

    private static InstallReferrerDataManager instance = null;

    public static InstallReferrerDataManager getInstance() {
        if (instance == null) {
            instance = new InstallReferrerDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {

    }

    @Override
    public void afterTransaction() {
        session.setIsReferrerUpdate("N");
        if (session.getAdIdChange().equals("Y")) {
            session.setAdIdChange("N");
            resetReferrer();
        }
        super.afterTransaction();
    }

    /**
     * Facebook 레퍼러 수신시 설정 메소드
     * @param bundle
     */
    public void setFacebookReferrer(Bundle bundle) {

        try {

            if (bundle == null) {
                return;
            }
            String referrer = null;
            if (bundle.containsKey(Const.FB_TARGET_URL) || bundle.containsKey(Const.FB_NATIVE_URL)) {
                referrer = bundle.getString(Const.FB_TARGET_URL);
                if (TextUtils.isEmpty(referrer)) {
                    referrer = bundle.getString(Const.FB_NATIVE_URL);
                    WiseLog.d("Facebook referrer: " + referrer.toString());
                }
            }
            if (bundle.containsKey(Const.FB_CLICK_TIME)) {
                String clickTime = bundle.getString(Const.FB_CLICK_TIME);
                if (TextUtils.isEmpty(clickTime)) {
                    referrer = referrer + "&_wtclkTime=" + clickTime;
                }
            }
            if (TextUtils.isEmpty(referrer)) {
                WiseLog.d("facebook referrer data is null or empty");
                return;
            }

            session.setIsReferrerUpdate("Y");
            session.setInstallReferrer(referrer);
            session.setBeginTime(0);
            session.setClickTime(0);
            //session.setReferrerType("FACEBOOK");
            setInstallReferrer(referrer);

        } catch (Exception e) {
            WiseLog.e("set facebook referrer get exception !!", e);
        }

    }

    /**
     * 인스톨 레퍼러 유효성 통과시 레퍼러 값 저장
     * @param referrerDetails
     */
    public void checkInstallReferrer(ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            WiseLog.d(" Google response is null");
            return;
        }
        this.checkInstallReferrer(referrerDetails.getInstallBeginTimestampSeconds(), referrerDetails.getReferrerClickTimestampSeconds(), referrerDetails.getInstallReferrer(), Const.GOOGLE_APP_STORE );
    }
    public void checkInstallReferrer(OneStoreInstallReferrerDataManager.ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            WiseLog.d("OneStore response is null");
            return;
        }
        this.checkInstallReferrer(referrerDetails.getInstallBeginTimestampSeconds(), referrerDetails.getReferrerClickTimestampSeconds(), referrerDetails.getInstallReferrer() , Const.ONESTORE );
    }

    private void checkInstallReferrer(long _beginTime, long _clickTime, String _referrer, String storeName) {
        try {

            long beginTime = _beginTime;
            long clickTime = _clickTime;
            WiseLog.d("ir begin time : " + beginTime);
            WiseLog.d("ir click time : " + clickTime);
            WiseLog.d("ir install referrer : "+ _referrer );

            String referrer = _referrer;
            if (TextUtils.isEmpty(referrer)) {
                WiseLog.d("install referrer data is null or empty");
                return;
            }

            boolean isWtc = referrer.contains("_wtc");
            boolean isWts = referrer.contains("_wts");
            if (!isWtc && !isWts) {
                WiseLog.d("invalid install referrer data");
                return;
            }
            session.setAppStoreName(storeName);
            session.setIsReferrerUpdate("Y");
            session.setInstallReferrer(referrer);
            session.setBeginTime(beginTime * TimeUtil.SECOND_MILLIS);
            session.setClickTime(clickTime * TimeUtil.SECOND_MILLIS);
            setInstallReferrer(referrer);

        } catch (Exception e) {
            WiseLog.e("check install referrer error !!", e);
        }

    }

    private void setInstallReferrer(String referrer) {
        Uri uri = Uri.parse(referrer);  //referrer.startsWith("http")?referrer: ("?"+referrer) );
        Set<String> queryParameters = uri.getQueryParameterNames();
        if (queryParameters == null || queryParameters.isEmpty()) {
            setInstallReferrerByMapParameter(referrer);
        } else {
            setInstallReferrerByQueryParameter(uri, queryParameters);
        }
        referrerValidation();
    }

    private void setInstallReferrerByQueryParameter(Uri uri, Set<String> queryParameters) {
        WiseLog.d("setInstallReferrerByQueryParameter called " + queryParameters.toString() );
        Iterator<String> iterator = queryParameters.iterator();
        while (iterator.hasNext()) {

            String name = iterator.next();
            switch (name) {
                case Const.WTS:
                    session.setAdInstallSource(uri.getQueryParameter(name));
                    break;
                case Const.WTM:
                    session.setAdInstallType(uri.getQueryParameter(name));
                    break;
                case Const.WTC:
                    session.setAdInstallCampaign(uri.getQueryParameter(name));
                    break;
                case Const.WTW:
                    session.setAdInstallKeyword(uri.getQueryParameter(name));
                    break;
                case Const.WTCLKTIME:
                    session.setAdInstallClickTime(ValueOf.longValue(uri.getQueryParameter(name)));
                    break;
                case Const.WTAFFID:
                    session.setInstallDepth1(uri.getQueryParameter(name));
                    break;
                case Const.WTBFFID:
                    session.setInstallDepth2(uri.getQueryParameter(name));
                    break;
                case Const.WTCKP:
                    session.setAdInstallExpireTime(ValueOf.intValue(uri.getQueryParameter(name)));
                    break;
                case Const.WTCID:
                    session.setClickId(uri.getQueryParameter(name));
                    break;
                case Const.WGCMPID:
                    session.setGoogleCampaignId(uri.getQueryParameter(name));
                    break;
            }

        }

    }

    private void setInstallReferrerByMapParameter(String referrer) {
        String[] map = referrer.split("&");
        List<String> parameters = Arrays.asList(map);
        WiseLog.d("setInstallReferrerByMapParameter called " + parameters );
        for (String query : parameters) {

            if (TextUtils.isEmpty(query)) {
                continue;
            }

            String[] data = query.split("=");
            if (data.length < 2) {
                continue;
            }

            String key = data[0];
            String value = data[1];

            switch (key) {
                case Const.WTS:
                    session.setAdInstallSource(value);
                    break;
                case Const.WTM:
                    session.setAdInstallType(value);
                    break;
                case Const.WTC:
                    session.setAdInstallCampaign(value);
                    break;
                case Const.WTW:
                    session.setAdInstallKeyword(value);
                    break;
                case Const.WTCLKTIME:
                    session.setAdInstallClickTime(ValueOf.longValue(value));
                    break;
                case Const.WTAFFID:
                    session.setInstallDepth1(value);
                    break;
                case Const.WTBFFID:
                    session.setInstallDepth2(value);
                    break;
                case Const.WTCKP:
                    session.setAdInstallExpireTime(ValueOf.intValue(value));
                    break;
                case Const.WTCID:
                    session.setClickId(value);
                    break;
                case Const.WGCMPID:
                    session.setGoogleCampaignId(value);
                    break;
            }

        }

    }

    private void referrerValidation() {
        String adInstallSource = session.getAdInstallSource();
        String adInstallCampaign = session.getAdInstallCampaign();
        if (TextUtils.isEmpty(adInstallSource) || TextUtils.isEmpty(adInstallCampaign)) {
            WiseLog.d("referrer doesn't have primary key");
            resetReferrer();
            return;
        }
        if (session.getAdInstallClickTime() == 0) {
            session.setAdInstallClickTime(System.currentTimeMillis());
        }
        if (session.getAdInstallClickTime() + (TimeUtil.MINUTE_MILLIS * session.getAdInstallExpireTime()) < System.currentTimeMillis()) {
            WiseLog.d("invalid install referrer");
            resetReferrer();
            return;
        }
    }

    private void resetReferrer() {
        session.setAdInstallSource(null);
        session.setAdInstallType(null);
        session.setAdInstallCampaign(null);
        session.setAdInstallKeyword(null);
        session.setAdInstallClickTime(0);
        session.setInstallDepth1(null);
        session.setInstallDepth2(null);
        session.setAdInstallExpireTime(0);
        session.setIsReferrerUpdate(null);
        session.setInstallReferrer(null);
        session.setBeginTime(0);
        session.setClickTime(0);
        session.setGoogleCampaignId(null);
        //session.setReferrerType(nullFACEBOOK" + " or " + "GOOGLE");
    }

}
