/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.text.TextUtils;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.manager.BaseDataManager;
import com.sdk.wisetracker.base.tracker.util.TimeUtil;
import java.util.UUID;

public class VisitDataManager
extends BaseDataManager {
    private static VisitDataManager instance = null;

    public static VisitDataManager getInstance() {
        if (instance == null) {
            instance = new VisitDataManager();
        }
        return instance;
    }

    @Override
    public void setData() {
        this.setPureSession();
        this.setVisitSession();
        this.setPurchaseSession();
    }

    @Override
    public void afterTransaction() {
        this.session.setFirstPurchase("N");
        this.session.setSpendingTimeToPurchase(0L);
        this.session.setSpendingVisitToPurchase(0);
        super.afterTransaction();
    }

    private void setPureSession() {
        try {
            long sessionTime = this.basicData.getLastSessionTime();
            if (sessionTime == 0L) {
                this.session.setDailyUnique("Y");
                this.session.setWeeklyUnique("Y");
                this.session.setWeeklyUnique2("Y");
                this.session.setMonthlyUnique("Y");
            } else {
                int day = TimeUtil.getInstance().getDay(sessionTime);
                int weekOfMonth = TimeUtil.getInstance().getWeekOfMonth(sessionTime);
                int month = TimeUtil.getInstance().getMonth(sessionTime);
                long currentTime = System.currentTimeMillis();
                int currentDay = TimeUtil.getInstance().getDay(currentTime);
                int currentWeekOfMonth = TimeUtil.getInstance().getWeekOfMonth(currentTime);
                int currentMonth = TimeUtil.getInstance().getMonth(currentTime);
                this.session.setDailyUnique(month == currentMonth && day == currentDay ? "N" : "Y");
                if (month == currentMonth && weekOfMonth == currentWeekOfMonth) {
                    this.session.setWeeklyUnique("N");
                } else {
                    this.session.setWeeklyUnique("Y");
                }
                this.session.setMonthlyUnique(month == currentMonth ? "N" : "Y");
                this.setWeeklyUnique(sessionTime);
            }
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    private void setWeeklyUnique(long time) {
        int dayOfWeek = TimeUtil.getInstance().getDayOfWeek(time);
        int weekOfMonth = TimeUtil.getInstance().getWeekOfMonth(time);
        int currentDayOfWeek = TimeUtil.getInstance().getDayOfWeek(System.currentTimeMillis());
        int currentWeekOfMonth = TimeUtil.getInstance().getWeekOfMonth(System.currentTimeMillis());
        if (weekOfMonth == currentWeekOfMonth) {
            if (dayOfWeek == 1 && currentDayOfWeek > 1) {
                this.session.setWeeklyUnique2("Y");
            } else {
                this.session.setWeeklyUnique2("N");
            }
        } else if (currentWeekOfMonth - weekOfMonth == 1) {
            if (currentDayOfWeek > 1) {
                this.session.setWeeklyUnique2("Y");
            } else {
                this.session.setWeeklyUnique2("N");
            }
        } else if (Math.abs(currentWeekOfMonth - weekOfMonth) > 1) {
            this.session.setWeeklyUnique2("Y");
        }
    }

    private void setVisitSession() {
        try {
            String sessionId = this.session.getSessionId();
            int sessionCount = this.session.getLifeCriteriaVisit();
            int purchaseSessionCount = this.session.getSpendingVisitToPurchase();
            int visitCount = this.session.getUserCriteriaVisit();
            long eventTime = this.basicData.getLastAppEventTime();
            int dailyTerm = TimeUtil.getInstance().dailyTerm(this.basicData.getFirstAppOpenTime());
            boolean isNew = TimeUtil.getInstance().newSession(eventTime);
            if (isNew) {
                sessionId = UUID.randomUUID().toString();
                ++sessionCount;
                ++purchaseSessionCount;
                visitCount = TimeUtil.getInstance().isExpire(eventTime) ? 1 : visitCount + 1;
                this.basicData.setLastSessionTime(System.currentTimeMillis());
                this.session.setPageKey(0);
            }
            this.basicData.setLastAppEventTime(System.currentTimeMillis());
            this.session.setSessionId(sessionId);
            this.session.setLifeCriteriaVisit(sessionCount);
            this.session.setSpendingVisitToPurchase(purchaseSessionCount);
            this.session.setUserCriteriaVisit(visitCount);
            this.session.setLifeVisitInterval(dailyTerm);
            this.session.setVisitNew(isNew ? "Y" : "N");
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    private void setPurchaseSession() {
        try {
            long purchaseTime = this.basicData.getLastPurchaseTime();
            int purchaseCount = this.session.getUserCriteriaPurchase();
            if (TimeUtil.getInstance().isExpire(purchaseTime)) {
                purchaseCount = 0;
            }
            this.session.setUserCriteriaPurchase(purchaseCount);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public void onPageEvent(String searchFail, String piTraceString) {
        try {
            this.session.setSearchFail(searchFail);
            String piTrace = this.session.getPiTrace();
            if (!TextUtils.isEmpty((CharSequence)piTraceString)) {
                piTrace = TextUtils.isEmpty((CharSequence)piTrace) ? "" : piTrace + "|";
                piTrace = piTrace + piTraceString;
            }
            this.session.setPiTrace(piTrace);
            this.session.setPageKey(this.session.getPageKey() + 1);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public void onPurchaseEvent(long lifePurchaseAmount, String orderNumber) {
        try {
            long purchaseTime = this.basicData.getLastPurchaseTime();
            if (purchaseTime == 0L) {
                this.session.setUserCriteriaPurchase(1);
                this.session.setLifeCriteriaPurchase(1);
                this.session.setLifePurchaseInterval(0);
                this.session.setFirstPurchase("Y");
            } else {
                this.session.setUserCriteriaPurchase(TimeUtil.getInstance().isExpire(purchaseTime) ? 1 : this.session.getUserCriteriaPurchase() + 1);
                this.session.setLifeCriteriaPurchase(this.session.getLifeCriteriaPurchase() + 1);
                this.session.setLifePurchaseInterval((int)((this.basicData.getFirstAppOpenTime() - purchaseTime) / 86400000L));
                this.session.setFirstPurchase("N");
            }
            this.basicData.setLastPurchaseTime(System.currentTimeMillis());
            this.session.setSpendingTimeToPurchase((System.currentTimeMillis() - this.basicData.getLastSessionTime()) / 1000L);
            this.session.setSpendingVisitToPurchase(0);
            this.session.setLastOrderNumber(orderNumber);
            this.session.setLifePurchaseAmount(this.session.getLifePurchaseAmount() + lifePurchaseAmount);
        }
        catch (Exception e) {
            WiseLog.e("on purchase action data set error !!", e);
        }
    }
}

