package com.sdk.wisetracker.base.tracker.network;

import com.google.gson.JsonObject;
import com.sdk.wisetracker.base.tracker.data.model.Referrer;
import com.sdk.wisetracker.base.tracker.data.model.Token;
import com.sdk.wisetracker.base.tracker.network.request.RequestError;
import com.sdk.wisetracker.base.tracker.network.request.RequestFingerPrint;
import com.sdk.wisetracker.base.tracker.network.request.RequestRetention;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Session API
 */
public interface SessionApi {

    @GET("token/v1/acsTokenRps.do")
    Observable<Token> getAccessToken(@Query("_wtno") String serviceNumber, @Query("_wPkg") String packageString);

    @POST("frp/v1/fingerPrintRps.do")
    Observable<Referrer> sendFingerPrint(@Body RequestFingerPrint requestFingerPrint);

    @POST("dot/v1/errorRcv.do")
    Observable<JsonObject> sendLog(@Body RequestError requestError);

    @POST("dot/v1/retentionRcv.do")
    Observable<JsonObject> sendRetention(@Body RequestRetention requestRetention);

    @POST("dot/v1/pushArrival.do")
    Observable<JsonObject> sendReceivedPush(@Query("_wtno") String serviceNumber, @Query("advtId") String adId, @Query("uuid") String uuid, @Query(value = "pushNo", encoded = true) String pushNumber, @Query("arrivalTime") long receiveTime);

}
