package com.sdk.wisetracker.base.tracker.network;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;

import java.util.concurrent.TimeUnit;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * 네트워크 요청시 생성되는 부모 class
 */
public abstract class BaseRetrofit<T> {

    private T api = null;
    private static final int TIME_OUT = 15;
    private HeaderType headerType = null;

    public abstract String getTag();

    public abstract String getUrl();

    public abstract Interceptor getHeaderInterceptor(HeaderType type);

    public abstract Interceptor getLogInterceptor();

    public T getBaseApi(Class<T> targetClass, HeaderType headerType) {

        try {

            if (this.headerType == null || !this.headerType.equals(headerType)) {
                Retrofit client = new Retrofit.Builder().baseUrl(getUrl())
                        .addConverterFactory(GsonConverterFactory.create())
                        .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                        .client(new OkHttpClient().newBuilder()
                                .retryOnConnectionFailure(false)
                                .connectTimeout(TIME_OUT, TimeUnit.SECONDS)
                                .addInterceptor(getHeaderInterceptor(headerType))
                                .addInterceptor(getLogInterceptor())
                                .build())
                        .build();
                api = client.create(targetClass);
                this.headerType = headerType;
            }
            return api;

        } catch (Exception e) {
            WiseLog.e(e);
        }

        return null;

    }

}
