package com.sdk.wisetracker.base.tracker.data.model;

import com.google.gson.annotations.SerializedName;

/**
 * SDK 내부 사용 Referrer 모델
 */
public class Referrer {

    private @SerializedName("wts") String adSource = null;
    private @SerializedName("wtm") String adType = null;
    private @SerializedName("wtc") String adCampaign = null;
    private @SerializedName("wtw") String adKeyword = null;
    private @SerializedName("wtcid") String clickId = null;
    private @SerializedName("wtref") String adLinkUrl = null;
    private @SerializedName("wtaffid") String depth1 = null;
    private @SerializedName("wtbffid") String depth2 = null;
    private @SerializedName("attributionPriorities") Priority priority = null;
    private @SerializedName("wtclkTime") long adClickTime = 0;
    private @SerializedName("responseTime") long fpResponseTime = 0;
    private @SerializedName("wtp") int adExpireDay = 0;
    private @SerializedName("itp") int adInstallExpireTime = 0;
    private @SerializedName("_wgcmpid") String googleCampaignId = null;

    public String getAdSource() {
        return adSource;
    }

    public String getAdType() {
        return adType;
    }

    public String getAdCampaign() {
        return adCampaign;
    }

    public String getAdKeyword() {
        return adKeyword;
    }

    public String getClickId() {
        return clickId;
    }

    public void setAdLinkUrl(String adLinkUrl) {
        this.adLinkUrl = adLinkUrl;
    }

    public String getAdLinkUrl() {
        return adLinkUrl;
    }

    public String getDepth1() {
        return depth1;
    }

    public String getDepth2() {
        return depth2;
    }

    public Priority getPriority() {
        return priority;
    }

    public long getAdClickTime() {
        return adClickTime;
    }

    public void setAdClickTime(long adClickTime) {
        this.adClickTime = adClickTime;
    }

    public long getFpResponseTime() {
        return fpResponseTime;
    }

    public int getAdExpireDay() {
        return adExpireDay;
    }

    public int getAdInstallExpireTime() {
        return adInstallExpireTime;
    }

    public String getGoogleCampaignId() {
        return googleCampaignId;
    }

}

