package com.sdk.wisetracker.base.tracker.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

/**
 * 내부 데이터 저장용 유틸 클래스
 */
public class WisetrackerDatabase {

    private static final String DATABASE_NAME = "WisetrackerDatabase";
    private static SharedPreferences sharedPreferences = null;

    public static void init(Context context) {
        try {
            sharedPreferences = context.getSharedPreferences(DATABASE_NAME, Context.MODE_PRIVATE);
        } catch (Exception e) {
            WiseLog.e(e);
        }
    }

    public static void setDatabase(String key, Object value) {

        try {

            if (sharedPreferences == null) {
                return;
            }

            if (value instanceof Long) {
                sharedPreferences.edit().putLong(key, (Long) value).apply();
            } else if (value instanceof Integer) {
                sharedPreferences.edit().putInt(key, (Integer) value).apply();
            } else if (value instanceof String) {
                if (TextUtils.isEmpty((String) value)) {
                    sharedPreferences.edit().putString(key, (String) value).apply();
                } else {
                    String encodingValue = URLEncoder.encode((String) value, "UTF-8");
                    sharedPreferences.edit().putString(key, encodingValue).apply();
                }
            }

        } catch (Exception e) {
            WiseLog.e(e);
        }

    }

    public static String getStringValue(String key) {

        try {

            if (sharedPreferences == null) {
                return null;
            }
            String data = sharedPreferences.getString(key, null);
            if (!TextUtils.isEmpty(data)) {
                data = URLDecoder.decode(data, "UTF-8");
            }
            return data;

        } catch (UnsupportedEncodingException e) {
            WiseLog.e(e);
        } catch (Exception e) {
            WiseLog.e(e);
        }

        return null;

    }

    public static int getIntValue(String key) {
        try {
            if (sharedPreferences == null) {
                return 0;
            }
            int data = sharedPreferences.getInt(key, 0);
            return data;
        } catch (Exception e) {
            WiseLog.e(e);
        }
        return 0;
    }

    public static long getLongValue(String key) {
        try {
            if (sharedPreferences == null) {
                return 0;
            }
            long data = sharedPreferences.getLong(key, 0);
            return data;
        } catch (Exception e) {
            WiseLog.e(e);
        }
        return 0;
    }

}
