/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.onestore.android.external.installreferrer.IGetInstallReferrerService;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.init.InitInstallReferrer;
import com.sdk.wisetracker.base.tracker.data.init.InitializeManager;
import java.net.URLDecoder;

public class OneStoreInstallReferrerDataManager {
    private static OneStoreInstallReferrerDataManager instance = null;
    private IGetInstallReferrerService mService;
    public static final String[] SERVICE_PACKAGE_NAMES = new String[]{"com.skt.skaf.A000Z00040", "com.kt.olleh.storefront", "com.kt.olleh.istore", "com.lguplus.appstore", "android.lgt.appstore"};
    public static final String SERVICE_NAME = "com.onestore.android.external.installreferrer.GetInstallReferrerService";
    public static final String SERVICE_ACTION_NAME = "com.onestore.android.external.BIND_GET_INSTALL_REFERRER_SERVICE";
    private static final int SUCCESS = 0;
    private static final int DB_ACCESS_FAIL = -1;
    private static final int NOT_FOUND_REFERRER = -2;
    private static final int NOT_ALLOWED_PACKAGE = -3;
    private static final int INVALID_PACKAGE_NAME = -4;
    private static final int ONESTORE_MIN_APP_VER = 60700;
    public ReferrerDetails mReferrerDetails;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder iBinder) {
            OneStoreInstallReferrerDataManager.this.mService = IGetInstallReferrerService.Stub.asInterface((IBinder)iBinder);
            Bundle bundle = null;
            try {
                bundle = OneStoreInstallReferrerDataManager.this.mService.getInstallReferrer(InitializeManager.applicationContext.getPackageName());
                WiseLog.d(" oneStore bundle " + bundle);
            }
            catch (RemoteException e) {
                WiseLog.d(" OneStore Service onServiceConnected RemoteException : " + e.toString());
            }
            if (bundle != null) {
                try {
                    OneStoreInstallReferrerDataManager.this.mReferrerDetails = new ReferrerDetails(bundle);
                }
                catch (DbAccessFailException dbAccessFailException) {
                }
                catch (NotFoundReferrerException notFoundReferrerException) {
                }
                catch (NotAllowedPackageException notAllowedPackageException) {
                }
                catch (InvalidPackageNameException invalidPackageNameException) {
                }
                catch (UnknownException unknownException) {
                }
                finally {
                    if (OneStoreInstallReferrerDataManager.this.mReferrerDetails == null) {
                        OneStoreInstallReferrerDataManager.this.mReferrerDetails = new ReferrerDetails();
                    }
                }
            } else {
                OneStoreInstallReferrerDataManager.this.mReferrerDetails = new ReferrerDetails();
            }
            System.out.println(" oneStoreObserveFlag false setting ");
            InitInstallReferrer.getInstance().oneStoreObserveFlag = false;
        }

        public void onServiceDisconnected(ComponentName name) {
            OneStoreInstallReferrerDataManager.this.mService = null;
            InitInstallReferrer.getInstance().oneStoreObserveFlag = false;
        }
    };

    public static OneStoreInstallReferrerDataManager getInstance() {
        if (instance == null) {
            instance = new OneStoreInstallReferrerDataManager();
        }
        return instance;
    }

    public ReferrerDetails getEmptyReferrer() {
        return new ReferrerDetails();
    }

    public boolean isOneStoreCompatible(String servicePackageName) {
        PackageManager pm = InitializeManager.applicationContext.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(servicePackageName, 128);
            int versionCode = info.versionCode;
            return versionCode >= 60700;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public ServiceConnection getmServiceConnection() {
        return this.mServiceConnection;
    }

    private class UnknownException
    extends Exception {
        public UnknownException(String errorMsg) {
            super(errorMsg);
        }
    }

    private class InvalidPackageNameException
    extends Exception {
        public InvalidPackageNameException(String errorMsg) {
            super(errorMsg);
        }
    }

    private class NotAllowedPackageException
    extends Exception {
        public NotAllowedPackageException(String errorMsg) {
            super(errorMsg);
        }
    }

    private class NotFoundReferrerException
    extends Exception {
        public NotFoundReferrerException(String errorMsg) {
            super(errorMsg);
        }
    }

    private class DbAccessFailException
    extends Exception {
        public DbAccessFailException(String errorMsg) {
            super(errorMsg);
        }
    }

    public class ReferrerDetails {
        public final String installReferrer;
        public final String onestorePid;
        public final long referrerClickTimeStampSeconds;
        public final long installBeginTimeStampSeconds;

        public String getInstallReferrer() {
            String result = this.installReferrer;
            try {
                if (result.indexOf("%26") >= 0 && result.indexOf("%3D") >= 0) {
                    result = URLDecoder.decode(result, "utf-8");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        public long getReferrerClickTimestampSeconds() {
            return this.referrerClickTimeStampSeconds;
        }

        public long getInstallBeginTimestampSeconds() {
            return this.installBeginTimeStampSeconds;
        }

        public ReferrerDetails() {
            this.installReferrer = "";
            this.onestorePid = "";
            this.referrerClickTimeStampSeconds = 0L;
            this.installBeginTimeStampSeconds = 0L;
        }

        public ReferrerDetails(Bundle bundle) throws DbAccessFailException, NotFoundReferrerException, NotAllowedPackageException, InvalidPackageNameException, UnknownException {
            int resultCode = bundle.getInt("result_code", -10);
            if (resultCode != 0) {
                if (resultCode == -1) {
                    throw new DbAccessFailException(bundle.getString("description", "DB_ACCESS_FAIL"));
                }
                if (resultCode == -2) {
                    throw new NotFoundReferrerException(bundle.getString("description", "NOT_FOUND_REFERRER"));
                }
                if (resultCode == -3) {
                    throw new NotAllowedPackageException(bundle.getString("description", "NOT_ALLOWED_PACKAGE"));
                }
                if (resultCode == -4) {
                    throw new InvalidPackageNameException(bundle.getString("description", "INVALID_PACKAGE_NAME"));
                }
                throw new UnknownException("resultCode is " + resultCode);
            }
            this.installReferrer = bundle.getString("install_referrer", "");
            this.onestorePid = bundle.getString("onestore_pid", "");
            this.referrerClickTimeStampSeconds = bundle.getLong("referrer_click_timestamp_seconds", -1L);
            this.installBeginTimeStampSeconds = bundle.getLong("install_begin_timestamp_seconds", -1L);
        }
    }
}

