/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.manager;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.init.ReferrerInitCallBack;
import com.sdk.wisetracker.base.tracker.data.manager.BasicData;
import com.sdk.wisetracker.base.tracker.data.manager.BasicDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.SessionDataManager;
import com.sdk.wisetracker.base.tracker.data.model.Priority;
import com.sdk.wisetracker.base.tracker.data.model.Referrer;
import com.sdk.wisetracker.base.tracker.data.model.Session;
import com.sdk.wisetracker.base.tracker.network.SessionApi;
import com.sdk.wisetracker.base.tracker.network.SessionRetrofit;
import com.sdk.wisetracker.base.tracker.network.request.RequestFingerPrint;
import com.sdk.wisetracker.base.tracker.network.type.HeaderType;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class FingerPrintDataManager {
    private static FingerPrintDataManager instance = null;
    private Session session = SessionDataManager.getInstance().getSession();

    public static FingerPrintDataManager getInstance() {
        if (instance == null) {
            instance = new FingerPrintDataManager();
        }
        return instance;
    }

    private RequestFingerPrint getRequestFingerPrint() {
        try {
            RequestFingerPrint requestFingerPrint = new RequestFingerPrint();
            requestFingerPrint.setServiceNumber(String.valueOf(this.session.getServiceNumber()));
            requestFingerPrint.setAdId(this.session.getAdId());
            requestFingerPrint.setVendorId(this.session.getVendorId());
            requestFingerPrint.setDeviceModel(Build.MODEL);
            requestFingerPrint.setOs(String.valueOf(Build.VERSION.SDK_INT));
            requestFingerPrint.setNew(BasicDataManager.getInstance().getBasicData().getIsFirstAppOpen().equals("Y"));
            requestFingerPrint.setClickTime(this.session.getAdClickTime());
            return requestFingerPrint;
        }
        catch (Exception e) {
            WiseLog.e(e);
            return null;
        }
    }

    private Observable<Referrer> getFingerPrintObservable() {
        SessionApi api = SessionRetrofit.getInstance().getBaseApi(SessionApi.class, HeaderType.FRP);
        return api.sendFingerPrint(this.getRequestFingerPrint()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @SuppressLint(value={"CheckResult"})
    public void loadFingerPrintByInstall(final ReferrerInitCallBack callBack) {
        try {
            this.getFingerPrintObservable().subscribe((Consumer)new Consumer<Referrer>(){

                public void accept(Referrer fingerPrint) {
                    if (fingerPrint != null) {
                        WiseLog.d("FingerPrint : " + new Gson().toJson((Object)fingerPrint));
                    }
                    if (!FingerPrintDataManager.this.isValidateFingerPrint(fingerPrint)) {
                        callBack.onCallback(true);
                        return;
                    }
                    if (FingerPrintDataManager.this.isEmptyReferrer(fingerPrint)) {
                        callBack.onCallback(true);
                        return;
                    }
                    FingerPrintDataManager.this.checkInstallReferrerPriority(fingerPrint);
                    callBack.onCallback(true);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    callBack.onCallback(true);
                    WiseLog.e("load finger print error !", throwable);
                }
            });
        }
        catch (Exception e) {
            WiseLog.e("load finger print error !", e);
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void loadFingerPrintByDeepLink() {
        try {
            this.getFingerPrintObservable().subscribe((Consumer)new Consumer<Referrer>(){

                public void accept(Referrer referrer) {
                    if (!FingerPrintDataManager.this.isValidateFingerPrint(referrer)) {
                        return;
                    }
                    FingerPrintDataManager.this.setDeepLink(referrer);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) {
                    WiseLog.e("load finger print error !", throwable);
                }
            });
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
    }

    private boolean isValidateFingerPrint(Referrer fingerPrint) {
        try {
            if (fingerPrint == null) {
                return false;
            }
            BasicData basicData = BasicDataManager.getInstance().getBasicData();
            long lastFingerPrintTime = basicData.getLastFingerPrintTime();
            long currentFingerPrintClickTime = fingerPrint.getAdClickTime();
            WiseLog.d("last finger print time : " + lastFingerPrintTime);
            WiseLog.d("current finger print click time : " + currentFingerPrintClickTime);
            if (lastFingerPrintTime != 0L && currentFingerPrintClickTime < lastFingerPrintTime) {
                return false;
            }
            basicData.setLastFingerPrintTime(System.currentTimeMillis());
            BasicDataManager.getInstance().saveBasicData(basicData);
            return true;
        }
        catch (Exception e) {
            WiseLog.e("check validate finger print error !", e);
            return false;
        }
    }

    private boolean isEmptyReferrer(Referrer fingerPrint) {
        String installSource = this.session.getAdInstallSource();
        String installCampaign = this.session.getAdInstallCampaign();
        if (TextUtils.isEmpty((CharSequence)installSource) || TextUtils.isEmpty((CharSequence)installCampaign)) {
            this.setInstallReferrer(fingerPrint);
            return true;
        }
        return false;
    }

    private void checkInstallReferrerPriority(Referrer fingerPrint) {
        try {
            String replaceType;
            int referrerPriority;
            String attributeType;
            Priority priority = fingerPrint.getPriority();
            if (priority == null) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)this.session.getClickId())) {
                attributeType = "ATR003";
                referrerPriority = priority.getReferrerPriority();
            } else {
                attributeType = "ATR001";
                referrerPriority = priority.getClickPriority();
                this.session.setClickId(null);
            }
            String link = fingerPrint.getAdLinkUrl();
            if (TextUtils.isEmpty((CharSequence)link)) {
                return;
            }
            Uri uri = Uri.parse((String)("?" + link));
            String fingerPrintType = uri.getQueryParameter("attriType");
            if (TextUtils.isEmpty((CharSequence)fingerPrintType)) {
                fingerPrintType = attributeType;
                replaceType = "attriType=";
            } else {
                replaceType = "attriType=" + fingerPrintType;
            }
            int fingerPrintPriority = fingerPrintType.equals("ATR002") ? priority.getAdvertisingPriority() : priority.getFingerPrintPriority();
            if (referrerPriority > fingerPrintPriority) {
                this.setInstallReferrer(fingerPrint);
            } else {
                String changeType = "attriType=" + attributeType;
                link = link.replace(replaceType, changeType);
                fingerPrint.setAdLinkUrl(link);
                this.session.setAdLinkUrl(link);
                SessionDataManager.getInstance().saveSession(this.session);
            }
        }
        catch (Exception e) {
            WiseLog.e("check finger print priority error !!", e);
        }
    }

    private boolean isValidDeepLink(Referrer deepLink) {
        int installExpireTime;
        long clickTime = deepLink.getAdClickTime();
        if (clickTime + (long)(86400000 * (installExpireTime = deepLink.getAdExpireDay())) < System.currentTimeMillis()) {
            WiseLog.d("invalid deep link fp");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.session.getAdCampaign()) || TextUtils.isEmpty((CharSequence)this.session.getAdSource())) {
            WiseLog.d("invalid data");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.session.getAdSource()) && !this.session.getAdSource().equals(deepLink.getAdSource())) {
            WiseLog.d("invalid data");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.session.getAdCampaign()) && !this.session.getAdCampaign().equals(deepLink.getAdCampaign())) {
            WiseLog.d("invalid data");
            return false;
        }
        if (this.session.getAdClickTime() == deepLink.getAdClickTime()) {
            WiseLog.d("invalid data");
            return false;
        }
        return true;
    }

    private void setDeepLink(Referrer deepLink) {
        if (!this.isValidDeepLink(deepLink)) {
            return;
        }
        WiseLog.d("set deep link by finger print");
        this.session.setAdSource(deepLink.getAdSource());
        this.session.setAdType(deepLink.getAdType());
        this.session.setAdCampaign(deepLink.getAdCampaign());
        this.session.setAdKeyword(deepLink.getAdKeyword());
        this.session.setAdClickTime(deepLink.getAdClickTime());
        this.session.setAdExpireDay(deepLink.getAdExpireDay());
        this.session.setDepth1(deepLink.getDepth1());
        this.session.setDepth2(deepLink.getDepth2());
        this.session.setAdLinkUrl(deepLink.getAdLinkUrl());
        this.session.setIsDeepLinkUpdate("Y");
        this.session.setGoogleCampaignId(deepLink.getGoogleCampaignId());
        SessionDataManager.getInstance().saveSession(this.session);
        SessionDataManager.deepLinkSubject.onNext((Object)true);
    }

    private boolean isValidInstallReferrer(Referrer installReferrer) {
        int installExpireTime;
        long clickTime = installReferrer.getAdClickTime();
        if (clickTime + (long)(60000 * (installExpireTime = installReferrer.getAdInstallExpireTime())) < System.currentTimeMillis()) {
            WiseLog.d("invalid install fp ");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)installReferrer.getAdSource()) || TextUtils.isEmpty((CharSequence)installReferrer.getAdCampaign())) {
            WiseLog.d("invalid install fp data");
            return false;
        }
        return true;
    }

    private void setInstallReferrer(Referrer installReferrer) {
        if (!this.isValidInstallReferrer(installReferrer)) {
            return;
        }
        WiseLog.d("set install referrer by finger print");
        this.session.setAdInstallSource(installReferrer.getAdSource());
        this.session.setAdInstallType(installReferrer.getAdType());
        this.session.setAdInstallCampaign(installReferrer.getAdCampaign());
        this.session.setAdInstallKeyword(installReferrer.getAdKeyword());
        this.session.setAdInstallClickTime(installReferrer.getAdClickTime());
        this.session.setAdInstallExpireTime(installReferrer.getAdInstallExpireTime());
        this.session.setInstallDepth1(installReferrer.getDepth1());
        this.session.setInstallDepth2(installReferrer.getDepth2());
        this.session.setInstallReferrer(installReferrer.getAdLinkUrl());
        this.session.setIsReferrerUpdate("Y");
        this.session.setGoogleCampaignId(installReferrer.getGoogleCampaignId());
        if (this.session.getAdExpireDay() == 0) {
            this.session.setAdExpireDay(installReferrer.getAdExpireDay());
        }
        SessionDataManager.getInstance().saveSession(this.session);
    }
}

