/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.data.init;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import com.sdk.wisetracker.base.tracker.data.init.InitializeManager;
import com.sdk.wisetracker.base.tracker.data.init.ReferrerInitCallBack;
import com.sdk.wisetracker.base.tracker.data.manager.FingerPrintDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.InstallReferrerDataManager;
import com.sdk.wisetracker.base.tracker.data.manager.OneStoreInstallReferrerDataManager;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Callable;

public class InitInstallReferrer {
    private static InitInstallReferrer instance = null;
    public boolean oneStoreObserveFlag = false;
    public boolean googleStoreObserveFlag = false;

    public static InitInstallReferrer getInstance() {
        if (instance == null) {
            instance = new InitInstallReferrer();
        }
        return instance;
    }

    private boolean isLoadReferrerAPI(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = appInfo.metaData;
            if (bundle != null && bundle.containsKey("disableDotReceiver")) {
                boolean isDisable = bundle.getBoolean("disableDotReceiver");
                WiseLog.d("sdk disable dot receiver");
                WiseLog.d("sdk disable value : " + isDisable);
                if (isDisable) {
                    return false;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            WiseLog.e(e);
        }
        catch (Exception e) {
            WiseLog.e(e);
        }
        return true;
    }

    public void loadInstallReferrer(Context context, final ReferrerInitCallBack callBack) {
        WiseLog.d("load referrer");
        if (!this.isLoadReferrerAPI(context)) {
            callBack.onCallback(true);
            return;
        }
        Observable<ReferrerDetails> googleReferrer = this.getGoogleInstallReferrer();
        Observable<OneStoreInstallReferrerDataManager.ReferrerDetails> oneStoreReferrer = this.getOneStoreInstallReferrer();
        Observable.zip(googleReferrer, oneStoreReferrer, (BiFunction)new BiFunction<ReferrerDetails, OneStoreInstallReferrerDataManager.ReferrerDetails, Object>(){

            public Object apply(ReferrerDetails google, OneStoreInstallReferrerDataManager.ReferrerDetails oneStore) {
                WiseLog.d("Observable.zip start! ");
                if (google != null && oneStore == null) {
                    return google;
                }
                if (google == null && oneStore != null) {
                    return oneStore;
                }
                long googleClkTime = google.getInstallBeginTimestampSeconds();
                long oneStoreClkTime = oneStore.getInstallBeginTimestampSeconds();
                if (googleClkTime > 0L && oneStoreClkTime == 0L) {
                    return google;
                }
                if (googleClkTime == 0L && oneStoreClkTime > 0L) {
                    return oneStore;
                }
                if (googleClkTime > oneStoreClkTime) {
                    return google;
                }
                if (googleClkTime < oneStoreClkTime) {
                    return oneStore;
                }
                if (google.getInstallReferrer() != null && !google.getInstallReferrer().equals("")) {
                    return google;
                }
                return "NoData";
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object _result) {
                WiseLog.d("Observable.zip result : " + _result);
                if (_result instanceof ReferrerDetails) {
                    InstallReferrerDataManager.getInstance().checkInstallReferrer((ReferrerDetails)_result);
                } else if (_result instanceof OneStoreInstallReferrerDataManager.ReferrerDetails) {
                    InstallReferrerDataManager.getInstance().checkInstallReferrer((OneStoreInstallReferrerDataManager.ReferrerDetails)_result);
                }
                FingerPrintDataManager.getInstance().loadFingerPrintByInstall(callBack);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                WiseLog.e(throwable);
            }
        });
    }

    Observable<OneStoreInstallReferrerDataManager.ReferrerDetails> getOneStoreInstallReferrer() {
        this.oneStoreObserveFlag = true;
        return Observable.fromCallable((Callable)new Callable<OneStoreInstallReferrerDataManager.ReferrerDetails>(){

            @Override
            public OneStoreInstallReferrerDataManager.ReferrerDetails call() {
                Intent serviceIntent = new Intent("com.onestore.android.external.BIND_GET_INSTALL_REFERRER_SERVICE");
                boolean connectionResult = false;
                for (String servicePackageName : OneStoreInstallReferrerDataManager.SERVICE_PACKAGE_NAMES) {
                    serviceIntent.setComponent(new ComponentName(servicePackageName, "com.onestore.android.external.installreferrer.GetInstallReferrerService"));
                    List intentServices = InitializeManager.applicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
                    if (intentServices == null || intentServices.isEmpty()) continue;
                    if (!OneStoreInstallReferrerDataManager.getInstance().isOneStoreCompatible(servicePackageName)) break;
                    connectionResult = InitializeManager.applicationContext.bindService(serviceIntent, OneStoreInstallReferrerDataManager.getInstance().getmServiceConnection(), 1);
                    break;
                }
                if (connectionResult) {
                    WiseLog.d(" OneStore Service connected!");
                    while (InitInstallReferrer.this.oneStoreObserveFlag) {
                    }
                    WiseLog.d("OneStore receive data : " + OneStoreInstallReferrerDataManager.getInstance().mReferrerDetails.getInstallReferrer());
                    return OneStoreInstallReferrerDataManager.getInstance().mReferrerDetails;
                }
                WiseLog.d(" OneStore Service not connected! Return Empty ");
                return OneStoreInstallReferrerDataManager.getInstance().getEmptyReferrer();
            }
        });
    }

    @SuppressLint(value={"CheckResult"})
    Observable<ReferrerDetails> getGoogleInstallReferrer() {
        this.googleStoreObserveFlag = true;
        return Observable.fromCallable((Callable)new Callable<ReferrerDetails>(){

            @Override
            public ReferrerDetails call() {
                final ReferrerDetails[] _receviedReferrer = new ReferrerDetails[]{null};
                try {
                    final InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder((Context)InitializeManager.applicationContext).build();
                    installReferrerClient.startConnection(new InstallReferrerStateListener(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void onInstallReferrerSetupFinished(int responseCode) {
                            try {
                                switch (responseCode) {
                                    case 0: {
                                        WiseLog.d("install referrer response is ok " + installReferrerClient.getInstallReferrer().getInstallReferrer());
                                        _receviedReferrer[0] = installReferrerClient.getInstallReferrer();
                                        return;
                                    }
                                    default: {
                                        WiseLog.d("install referrer response is not ok");
                                        return;
                                    }
                                }
                            }
                            catch (RemoteException re) {
                                WiseLog.d("get install begin time error !!" + re.getMessage());
                                return;
                            }
                            catch (Exception e) {
                                WiseLog.d("exception occurs !!" + e.getMessage());
                                return;
                            }
                            finally {
                                InitInstallReferrer.this.googleStoreObserveFlag = false;
                            }
                        }

                        public void onInstallReferrerServiceDisconnected() {
                            WiseLog.d("onInstallReferrerServiceDisconnected !!");
                            InitInstallReferrer.this.googleStoreObserveFlag = false;
                        }
                    });
                }
                catch (Exception e) {
                    WiseLog.d("get server time error !! " + e.getMessage());
                }
                while (InitInstallReferrer.this.googleStoreObserveFlag) {
                }
                WiseLog.d("Google receive data : " + _receviedReferrer[0].getInstallReferrer());
                return _receviedReferrer[0];
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }
}

