package com.sdk.wisetracker.base.tracker.data.manager;

import com.sdk.wisetracker.base.tracker.data.model.Session;

/**
 * 세션 데이터 관리 매니져 공통 부모 class
 */
public abstract class BaseDataManager implements ISessionDataManager {

    protected BasicData basicData;
    protected Session session;

    public BaseDataManager() {
        basicData = BasicDataManager.getInstance().getBasicData();
        session = SessionDataManager.getInstance().getSession();
    }

    @Override
    public void afterTransaction() {
        BasicDataManager.getInstance().saveBasicData(basicData);
        SessionDataManager.getInstance().saveSession(session);
    }

}
