package com.sdk.wisetracker.base.tracker.common.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Log;

import com.sdk.wisetracker.base.tracker.common.log.WiseLog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;

public class ConnectHelper {

    private static ConnectHelper instance = null;
    private Context context = null;

    public static ConnectHelper getInstance() {
        if (instance == null) {
            instance = new ConnectHelper();
        }
        return instance;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @SuppressLint("CheckResult")
    public void networkStatus(String TAG, IConnection iConnection) {
        Observable<Boolean> o1 = checkNetworkConnection(TAG);
        Observable<Boolean> o2 = checkNetworkStatus(TAG);
        Observable.zip(o1, o2, new BiFunction<Boolean, Boolean, Boolean>() {
            @Override
            public Boolean apply(Boolean aBoolean, Boolean aBoolean2) {
                if (!aBoolean || !aBoolean2) {
                    return false;
                }
                return true;
            }
        }).subscribe(new Consumer<Boolean>() {
            @Override
            public void accept(Boolean isConnect) {
                if (iConnection != null) {
                    iConnection.onConnection(isConnect);
                }
            }
        }, new Consumer<Throwable>() {
            @Override
            public void accept(Throwable throwable) {
                Log.e(TAG, "check network status zip error !!", throwable);
            }
        });
    }

    private Observable<Boolean> checkNetworkConnection(String TAG) {
        return Observable
                .timer(100, TimeUnit.MILLISECONDS)
                .flatMap(new Function<Long, ObservableSource<String>>() {
                    @Override
                    public ObservableSource<String> apply(Long aLong) {
                        try {
                            if (context == null) {
                                return Observable.just("context is null");
                            }
                            ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
                            if (connectivityManager == null) {
                                return Observable.just("connectivityManager is null");
                            }
                            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                            if (networkInfo == null) {
                                return Observable.just("network info is null");
                            }
                            if (networkInfo.isConnected()) {
                                return Observable.just("");
                            } else {
                                return Observable.just("network connection false");
                            }
                        } catch (Exception e) {
                            return Observable.just(e.getMessage());
                        }
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .flatMap(new Function<String, ObservableSource<Boolean>>() {
                    @Override
                    public ObservableSource<Boolean> apply(String message) {
                        if (TextUtils.isEmpty(message)) {
                            WiseLog.d("network connection check true");
                            return Observable.just(true);
                        } else {
                            WiseLog.d("network connection check : " + message);
                            return Observable.just(false);
                        }
                    }
                });
    }

    private Observable<Boolean> checkNetworkStatus(String TAG) {

        return Observable
                .timer(100, TimeUnit.MILLISECONDS)
                .flatMap(new Function<Long, ObservableSource<String>>() {
                    @Override
                    public ObservableSource<String> apply(Long aLong) {

                        try {

                            String proxyUrl = System.getProperty("http.proxyHost");
                            if (TextUtils.isEmpty(proxyUrl)) {
                                WiseLog.d("doesn't have http.proxyHost data");
                                return Observable.just("");
                            }
                            WiseLog.d("proxy url : " + proxyUrl);
                            URL myUrl = new URL("http://" + proxyUrl);
                            URLConnection connection = myUrl.openConnection();
                            connection.setConnectTimeout(5000);
                            connection.connect();
                            return Observable.just("");

                        } catch (MalformedURLException e) {
                            return Observable.just(e.getMessage());
                        } catch (IOException e) {
                            return Observable.just(e.getMessage());
                        } catch (Exception e) {
                            return Observable.just(e.getMessage());
                        }

                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .flatMap(new Function<String, ObservableSource<Boolean>>() {
                    @Override
                    public ObservableSource<Boolean> apply(String message) {
                        if (TextUtils.isEmpty(message)) {
                            WiseLog.d("proxy network check true");
                            return Observable.just(true);
                        } else {
                            WiseLog.d("proxy network check : " + message);
                            return Observable.just(false);
                        }
                    }
                });

    }

}
