package com.sdk.wisetracker.base.open.model;

import com.google.gson.annotations.SerializedName;

/**
 * 고객사 SDK 전달 모델 객체
 */
public class User {

    private @SerializedName("isLogin") boolean isLogin;
    private @SerializedName("mbr") String member;
    private @SerializedName("mbl") String memberGrade;
    private @SerializedName("mbid") String memberId;
    private @SerializedName("sx") String gender;
    private @SerializedName("ag") String age;
    private @SerializedName("ut1") String attr1;
    private @SerializedName("ut2") String attr2;
    private @SerializedName("ut3") String attr3;
    private @SerializedName("ut4") String attr4;
    private @SerializedName("ut5") String attr5;
    private @SerializedName("loginTp") String loginTp;
    private @SerializedName("signupTp") String signupTp;

    public User(Builder builder) {
        member = builder.member;
        memberGrade = builder.memberGrade;
        memberId = builder.memberId;
        gender = builder.gender;
        age = builder.age;
        attr1 = builder.attr1;
        attr2 = builder.attr2;
        attr3 = builder.attr3;
        attr4 = builder.attr4;
        attr5 = builder.attr5;
        isLogin = builder.isLogin;
        loginTp = builder.loginTp;
        signupTp = builder.signupTp;
    }

    public boolean isLogin() {
        return isLogin;
    }

    public String getMember() {
        return member;
    }

    public String getMemberGrade() {
        return memberGrade;
    }

    public String getMemberId() {
        return memberId;
    }

    public String getGender() {
        return gender;
    }

    public String getAge() {
        return age;
    }

    public String getAttr1() {
        return attr1;
    }

    public String getAttr2() {
        return attr2;
    }

    public String getAttr3() {
        return attr3;
    }

    public String getAttr4() {
        return attr4;
    }

    public String getAttr5() {
        return attr5;
    }

    public String getSignupTp() {
        return signupTp;
    }

    public String getLoginTp() { return loginTp; }

    public static class Builder {

        private boolean isLogin = false;
        private String member = null;
        private String memberGrade = null;
        private String memberId = null;
        private String gender = null;
        private String age = null;
        private String attr1 = null;
        private String attr2 = null;
        private String attr3 = null;
        private String attr4 = null;
        private String attr5 = null;
        private String signupTp = null;
        private String loginTp = null;
        public Builder setMember(String member) {
            this.member = member;
            return this;
        }

        public Builder setMemberGrade(String memberGrade) {
            this.memberGrade = memberGrade;
            return this;
        }

        public Builder setMemberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public Builder setGender(String gender) {
            this.gender = gender;
            return this;
        }

        public Builder setAge(String age) {
            this.age = age;
            return this;
        }

        public Builder setAttr1(String attr1) {
            this.attr1 = attr1;
            return this;
        }

        public Builder setAttr2(String attr2) {
            this.attr2 = attr2;
            return this;
        }

        public Builder setAttr3(String attr3) {
            this.attr3 = attr3;
            return this;
        }

        public Builder setAttr4(String attr4) {
            this.attr4 = attr4;
            return this;
        }

        public Builder setAttr5(String attr5) {
            this.attr5 = attr5;
            return this;
        }

        public Builder setSignupTp(String signupTp) {
            this.signupTp = signupTp;
            return this;
        }

        public Builder setLoginTp(String loginTp) {
            this.loginTp = loginTp;
            return this;
        }

        public User build() {
            isLogin = true;
            return new User(this);
        }

    }

}
