/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.wisetracker.base.tracker.network.interceptor;

import android.util.Log;
import com.sdk.wisetracker.base.tracker.common.log.WiseLog;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RetrofitLogInterceptor
implements Interceptor {
    private String tag;

    public RetrofitLogInterceptor(String tag) {
        this.tag = tag;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        try {
            Request request = chain.request();
            Response response = chain.proceed(request);
            String rawJson = response.body().string();
            WiseLog.d("SERVER RESPONSE -> " + rawJson);
            return response.newBuilder().body(ResponseBody.create((MediaType)response.body().contentType(), (String)rawJson)).build();
        }
        catch (IOException e) {
            Log.e((String)this.tag, (String)"retrofit io exception", (Throwable)e);
        }
        catch (Exception e) {
            Log.e((String)this.tag, (String)"retrofit intercept error !!", (Throwable)e);
        }
        return chain.proceed(chain.request().newBuilder().build());
    }
}

