/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.testinfra.ccm.BaseCcmRule;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.categories.ParallelizableTests;
import java.lang.reflect.Method;
import org.junit.AssumptionViolatedException;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcmRule
extends BaseCcmRule {
    private static final CcmRule INSTANCE = new CcmRule();
    private volatile boolean started = false;

    private CcmRule() {
        super(CcmRule.configureCcmBridge(CcmBridge.builder()).build());
    }

    public static CcmBridge.Builder configureCcmBridge(CcmBridge.Builder builder) {
        Logger logger = LoggerFactory.getLogger(CcmRule.class);
        String customizerClass = System.getProperty("ccmrule.bridgecustomizer", "com.datastax.oss.driver.api.testinfra.ccm.DefaultCcmBridgeBuilderCustomizer");
        try {
            Class<?> clazz = Class.forName(customizerClass);
            Method method = clazz.getMethod("configureBuilder", CcmBridge.Builder.class);
            return (CcmBridge.Builder)method.invoke(null, builder);
        }
        catch (Exception e) {
            logger.warn("Could not find CcmRule customizer {}, will use the default CcmBridge.", (Object)customizerClass, (Object)e);
            return builder;
        }
    }

    @Override
    protected synchronized void before() {
        if (!this.started) {
            super.before();
            this.started = true;
        }
    }

    @Override
    protected void after() {
    }

    @Override
    public Statement apply(Statement base, final Description description) {
        Category categoryAnnotation = description.getTestClass().getAnnotation(Category.class);
        if (categoryAnnotation == null || categoryAnnotation.value().length != 1 || categoryAnnotation.value()[0] != ParallelizableTests.class) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Tests using %s must be annotated with `@Category(%s.class)`. Description: %s", CcmRule.class.getSimpleName(), ParallelizableTests.class.getSimpleName(), description));
                }
            };
        }
        return super.apply(base, description);
    }

    public void reloadCore(int node, String keyspace, String table, boolean reindex) {
        this.ccmBridge.reloadCore(node, keyspace, table, reindex);
    }

    public static CcmRule getInstance() {
        return INSTANCE;
    }
}

