/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.requirement;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraRequirement;
import com.datastax.oss.driver.api.testinfra.DseRequirement;
import com.datastax.oss.driver.api.testinfra.ScyllaRequirement;
import com.datastax.oss.driver.api.testinfra.ScyllaSkip;
import com.datastax.oss.driver.api.testinfra.requirement.BackendRequirement;
import com.datastax.oss.driver.api.testinfra.requirement.BackendRequirements;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.runner.Description;

public class VersionRequirement {
    final BackendType backendType;
    final Optional<Version> minInclusive;
    final Optional<Version> maxExclusive;
    final String description;

    public VersionRequirement(BackendType backendType, String minInclusive, String maxExclusive, String description) {
        this.backendType = backendType;
        this.minInclusive = minInclusive.isEmpty() ? Optional.empty() : Optional.of(Version.parse((String)minInclusive));
        this.maxExclusive = maxExclusive.isEmpty() ? Optional.empty() : Optional.of(Version.parse((String)maxExclusive));
        this.description = description;
    }

    public BackendType getBackendType() {
        return this.backendType;
    }

    public Optional<Version> getMinInclusive() {
        return this.minInclusive;
    }

    public Optional<Version> getMaxExclusive() {
        return this.maxExclusive;
    }

    public String readableString() {
        String versionRange = this.minInclusive.isPresent() && this.maxExclusive.isPresent() ? String.format("%s or greater, but less than %s", this.minInclusive.get(), this.maxExclusive.get()) : (this.minInclusive.isPresent() ? String.format("%s or greater", this.minInclusive.get()) : (this.maxExclusive.isPresent() ? String.format("less than %s", this.maxExclusive.get()) : "any version"));
        if (!this.description.isEmpty()) {
            return String.format("%s %s [%s]", this.backendType.getFriendlyName(), versionRange, this.description);
        }
        return String.format("%s %s", this.backendType.getFriendlyName(), versionRange);
    }

    public static VersionRequirement fromBackendRequirement(BackendRequirement requirement) {
        return new VersionRequirement(requirement.type(), requirement.minInclusive(), requirement.maxExclusive(), requirement.description());
    }

    public static VersionRequirement fromCassandraRequirement(CassandraRequirement requirement) {
        return new VersionRequirement(BackendType.CASSANDRA, requirement.min(), requirement.max(), requirement.description());
    }

    public static VersionRequirement fromDseRequirement(DseRequirement requirement) {
        return new VersionRequirement(BackendType.DSE, requirement.min(), requirement.max(), requirement.description());
    }

    public static VersionRequirement fromScyllaOssRequirement(ScyllaRequirement requirement) {
        return new VersionRequirement(BackendType.SCYLLA, requirement.minOSS(), !requirement.maxOSS().isEmpty() ? requirement.maxOSS() : "2000.0.0", requirement.description());
    }

    public static VersionRequirement fromScyllaEnterpriseRequirement(ScyllaRequirement requirement) {
        return new VersionRequirement(BackendType.SCYLLA, !requirement.minEnterprise().isEmpty() ? requirement.minEnterprise() : "2000.0.0", requirement.maxEnterprise(), requirement.description());
    }

    public static Collection<VersionRequirement> fromAnnotations(Description description) {
        CassandraRequirement cassandraRequirement = (CassandraRequirement)description.getAnnotation(CassandraRequirement.class);
        DseRequirement dseRequirement = (DseRequirement)description.getAnnotation(DseRequirement.class);
        ScyllaRequirement scyllaRequirement = (ScyllaRequirement)description.getAnnotation(ScyllaRequirement.class);
        BackendRequirement backendRequirement = (BackendRequirement)description.getAnnotation(BackendRequirement.class);
        BackendRequirements backendRequirements = (BackendRequirements)description.getAnnotation(BackendRequirements.class);
        ScyllaSkip scyllaSkip = (ScyllaSkip)description.getAnnotation(ScyllaSkip.class);
        ArrayList<VersionRequirement> requirements = new ArrayList<VersionRequirement>();
        if (cassandraRequirement != null) {
            requirements.add(VersionRequirement.fromCassandraRequirement(cassandraRequirement));
        }
        if (dseRequirement != null) {
            requirements.add(VersionRequirement.fromDseRequirement(dseRequirement));
        }
        if (scyllaSkip != null) {
            requirements.add(new VersionRequirement(BackendType.SCYLLA, "0.0.0", "1.0.0", scyllaSkip.description()));
        }
        if (scyllaRequirement != null) {
            if (!scyllaRequirement.minEnterprise().isEmpty() || !scyllaRequirement.maxEnterprise().isEmpty()) {
                requirements.add(VersionRequirement.fromScyllaEnterpriseRequirement(scyllaRequirement));
            }
            if (!scyllaRequirement.minOSS().isEmpty() || !scyllaRequirement.maxOSS().isEmpty()) {
                requirements.add(VersionRequirement.fromScyllaOssRequirement(scyllaRequirement));
            }
        }
        if (backendRequirement != null) {
            requirements.add(VersionRequirement.fromBackendRequirement(backendRequirement));
        }
        if (backendRequirements != null) {
            Arrays.stream(backendRequirements.value()).forEach(r -> requirements.add(VersionRequirement.fromBackendRequirement(r)));
        }
        return requirements;
    }

    public static boolean meetsAny(Collection<VersionRequirement> requirements, BackendType configuredBackend, Version configuredVersion) {
        if (requirements.isEmpty()) {
            return true;
        }
        return requirements.stream().anyMatch(requirement -> {
            if (requirement.getBackendType() != configuredBackend) {
                return false;
            }
            if (requirement.getMinInclusive().isPresent() && requirement.getMinInclusive().get().compareTo(configuredVersion) > 0) {
                return false;
            }
            return !requirement.getMaxExclusive().isPresent() || requirement.getMaxExclusive().get().compareTo(configuredVersion) > 0;
        });
    }

    public static String buildReasonString(Collection<VersionRequirement> requirements, BackendType backend, Version version) {
        return String.format("Test requires one of:\n%s\nbut configuration is %s %s.", requirements.stream().map(req -> String.format("  - %s", req.readableString())).collect(Collectors.joining("\n")), backend.getFriendlyName(), version);
    }
}

