/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.requirement;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.api.testinfra.requirement.VersionRequirement;
import org.junit.AssumptionViolatedException;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BackendRequirementRule
extends ExternalResource {
    public Statement apply(Statement base, final Description description) {
        if (BackendRequirementRule.meetsDescriptionRequirements(description)) {
            return super.apply(base, description);
        }
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(BackendRequirementRule.buildReasonString(description));
            }
        };
    }

    protected static BackendType getBackendType() {
        return CcmBridge.DSE_ENABLEMENT != false ? BackendType.DSE : BackendType.CASSANDRA;
    }

    protected static Version getVersion() {
        return CcmBridge.VERSION;
    }

    public static boolean meetsDescriptionRequirements(Description description) {
        return VersionRequirement.meetsAny(VersionRequirement.fromAnnotations(description), BackendRequirementRule.getBackendType(), BackendRequirementRule.getVersion());
    }

    public static String buildReasonString(Description description) {
        return VersionRequirement.buildReasonString(VersionRequirement.fromAnnotations(description), BackendRequirementRule.getBackendType(), BackendRequirementRule.getVersion());
    }
}

