/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraRequirement;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.CassandraSkip;
import com.datastax.oss.driver.api.testinfra.DseRequirement;
import com.datastax.oss.driver.api.testinfra.ScyllaRequirement;
import com.datastax.oss.driver.api.testinfra.ScyllaSkip;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import com.datastax.oss.driver.api.testinfra.requirement.VersionRequirement;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.remove();
    }

    private Statement buildErrorStatement(final Version requirement, final String description, final boolean lessThan, final boolean dse) {
        return new Statement(){

            public void evaluate() {
                Object[] objectArray = new Object[5];
                Object object = objectArray[0] = lessThan ? "less than" : "at least";
                objectArray[1] = dse ? "DSE" : (CcmBridge.SCYLLA_ENABLEMENT != false ? "SCYLLA" : "C*");
                objectArray[2] = requirement;
                objectArray[3] = dse ? BaseCcmRule.this.ccmBridge.getDseVersion().orElse(null) : (CcmBridge.SCYLLA_ENABLEMENT != false ? BaseCcmRule.this.ccmBridge.getScyllaVersion().orElse(null) : BaseCcmRule.this.ccmBridge.getCassandraVersion());
                objectArray[4] = description;
                throw new AssumptionViolatedException(String.format("Test requires %s %s %s but %s is configured.  Description: %s", objectArray));
            }
        };
    }

    public Statement apply(Statement base, final Description description) {
        ScyllaRequirement scyllaRequirement;
        DseRequirement dseRequirement;
        final BackendType backend = this.ccmBridge.getDseVersion().isPresent() ? BackendType.DSE : BackendType.CASSANDRA;
        final Version version = this.ccmBridge.getDseVersion().orElseGet(this.ccmBridge::getCassandraVersion);
        final Collection<VersionRequirement> requirements = VersionRequirement.fromAnnotations(description);
        if (!VersionRequirement.meetsAny(requirements, backend, version)) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(VersionRequirement.buildReasonString(requirements, backend, version));
                }
            };
        }
        ScyllaSkip scyllaSkip = (ScyllaSkip)description.getAnnotation(ScyllaSkip.class);
        if (scyllaSkip != null && CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running with Scylla.  Description: %s", description));
                }
            };
        }
        CassandraSkip cassandraSkip = (CassandraSkip)description.getAnnotation(CassandraSkip.class);
        if (cassandraSkip != null && !CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running with Cassandra.  Description: %s", description));
                }
            };
        }
        CassandraRequirement cassandraRequirement = (CassandraRequirement)description.getAnnotation(CassandraRequirement.class);
        if (cassandraRequirement != null) {
            Version maxVersion;
            Version minVersion;
            if (!cassandraRequirement.min().isEmpty() && (minVersion = Version.parse((String)cassandraRequirement.min())).compareTo(this.ccmBridge.getCassandraVersion()) > 0) {
                return this.buildErrorStatement(minVersion, cassandraRequirement.description(), false, false);
            }
            if (!cassandraRequirement.max().isEmpty() && (maxVersion = Version.parse((String)cassandraRequirement.max())).compareTo(this.ccmBridge.getCassandraVersion()) <= 0) {
                return this.buildErrorStatement(maxVersion, cassandraRequirement.description(), true, false);
            }
        }
        if ((dseRequirement = (DseRequirement)description.getAnnotation(DseRequirement.class)) != null) {
            Version maxVersion;
            Version minVersion;
            Optional<Version> dseVersionOption = this.ccmBridge.getDseVersion();
            if (!dseVersionOption.isPresent()) {
                return new Statement(){

                    public void evaluate() {
                        throw new AssumptionViolatedException("Test Requires DSE but C* is configured.");
                    }
                };
            }
            Version dseVersion = dseVersionOption.get();
            if (!dseRequirement.min().isEmpty() && (minVersion = Version.parse((String)dseRequirement.min())).compareTo(dseVersion) > 0) {
                return this.buildErrorStatement(minVersion, dseRequirement.description(), false, true);
            }
            if (!dseRequirement.max().isEmpty() && (maxVersion = Version.parse((String)dseRequirement.max())).compareTo(dseVersion) <= 0) {
                return this.buildErrorStatement(maxVersion, dseRequirement.description(), true, true);
            }
        }
        if ((scyllaRequirement = (ScyllaRequirement)description.getAnnotation(ScyllaRequirement.class)) != null) {
            Optional<Version> scyllaVersionOption = this.ccmBridge.getScyllaVersion();
            if (!scyllaVersionOption.isPresent()) {
                return new Statement(){

                    public void evaluate() {
                        throw new AssumptionViolatedException("Test has Scylla version requirement, but CCMBridge is not configured for Scylla.");
                    }
                };
            }
            Version scyllaVersion = scyllaVersionOption.get();
            if (CcmBridge.SCYLLA_ENTERPRISE.booleanValue()) {
                Version maxVersion;
                Version minVersion;
                if (!scyllaRequirement.minEnterprise().isEmpty() && (minVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.minEnterprise()))).compareTo(scyllaVersion) > 0) {
                    return this.buildErrorStatement(minVersion, scyllaRequirement.description(), false, false);
                }
                if (!scyllaRequirement.maxEnterprise().isEmpty() && (maxVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.maxEnterprise()))).compareTo(scyllaVersion) <= 0) {
                    return this.buildErrorStatement(maxVersion, scyllaRequirement.description(), true, false);
                }
            } else {
                Version maxVersion;
                Version minVersion;
                if (!scyllaRequirement.minOSS().isEmpty() && (minVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.minOSS()))).compareTo(scyllaVersion) > 0) {
                    return this.buildErrorStatement(minVersion, scyllaRequirement.description(), false, false);
                }
                if (!scyllaRequirement.maxOSS().isEmpty() && (maxVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.maxOSS()))).compareTo(CcmBridge.VERSION) <= 0) {
                    return this.buildErrorStatement(maxVersion, scyllaRequirement.description(), true, false);
                }
            }
        }
        return super.apply(base, description);
    }

    public Version getCassandraVersion() {
        return this.ccmBridge.getCassandraVersion();
    }

    public Optional<Version> getDseVersion() {
        return this.ccmBridge.getDseVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (this.ccmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }
}

