/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.select.OngoingSelection;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.internal.core.CqlIdentifiers;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Map;

public interface Select
extends OngoingSelection,
OngoingWhereClause<Select>,
BuildableQuery {
    @NonNull
    public Select groupBy(@NonNull Iterable<Selector> var1);

    @NonNull
    default public Select groupBy(Selector ... selectors) {
        return this.groupBy(Arrays.asList(selectors));
    }

    @NonNull
    default public Select groupByColumnIds(@NonNull Iterable<CqlIdentifier> columnIds) {
        return this.groupBy(Iterables.transform(columnIds, Selector::column));
    }

    @NonNull
    default public Select groupByColumnIds(CqlIdentifier ... columnIds) {
        return this.groupByColumnIds(Arrays.asList(columnIds));
    }

    @NonNull
    default public Select groupByColumns(@NonNull Iterable<String> columnNames) {
        return this.groupBy(Iterables.transform(columnNames, Selector::column));
    }

    @NonNull
    default public Select groupByColumns(String ... columnNames) {
        return this.groupByColumns(Arrays.asList(columnNames));
    }

    @NonNull
    public Select groupBy(@NonNull Selector var1);

    @NonNull
    default public Select groupBy(@NonNull CqlIdentifier columnId) {
        return this.groupBy(Selector.column(columnId));
    }

    @NonNull
    default public Select groupBy(@NonNull String columnName) {
        return this.groupBy(Selector.column(columnName));
    }

    @NonNull
    public Select orderByIds(@NonNull Map<CqlIdentifier, ClusteringOrder> var1);

    @NonNull
    default public Select orderBy(@NonNull Map<String, ClusteringOrder> orderings) {
        return this.orderByIds(CqlIdentifiers.wrapKeys(orderings));
    }

    @NonNull
    public Select orderBy(@NonNull CqlIdentifier var1, @NonNull ClusteringOrder var2);

    @NonNull
    default public Select orderBy(@NonNull String columnName, @NonNull ClusteringOrder order) {
        return this.orderBy(CqlIdentifier.fromCql((String)columnName), order);
    }

    @NonNull
    public Select limit(int var1);

    @NonNull
    public Select limit(@Nullable BindMarker var1);

    @NonNull
    public Select perPartitionLimit(int var1);

    @NonNull
    public Select perPartitionLimit(@Nullable BindMarker var1);

    @NonNull
    public Select allowFiltering();

    @NonNull
    public Select usingTimeout(@NonNull CqlDuration var1);

    @NonNull
    public Select usingTimeout(@NonNull BindMarker var1);

    @NonNull
    public Select bypassCache();
}

