/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.MetricPaths;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileNodeMetricUpdater;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileSessionMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Ticker;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MicroProfileMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MicroProfileMetricsFactory.class);
    static final Duration LOWEST_ACCEPTABLE_EXPIRE_AFTER = Duration.ofMinutes(5L);
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    private final SessionMetricUpdater sessionUpdater;
    private final Cache<Node, MicroProfileNodeMetricUpdater> metricsCache;

    public MicroProfileMetricsFactory(InternalDriverContext context, MetricRegistry registry, Ticker ticker) {
        this.context = context;
        String logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set enabledSessionMetrics = MetricPaths.parseSessionMetricPaths((List)config.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED), (String)logPrefix);
        this.enabledNodeMetrics = MetricPaths.parseNodeMetricPaths((List)config.getStringList((DriverOption)DefaultDriverOption.METRICS_NODE_ENABLED), (String)logPrefix);
        Duration evictionTime = MicroProfileMetricsFactory.getAndValidateEvictionTime(config, logPrefix);
        this.metricsCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterAccess(evictionTime).removalListener(notification -> {
            LOG.debug("[{}] Removing metrics for node: {} from cache after {}", new Object[]{logPrefix, notification.getKey(), evictionTime});
            ((MicroProfileNodeMetricUpdater)notification.getValue()).cleanupNodeMetrics();
        }).build();
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled.", (Object)logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
        } else {
            this.registry = registry;
            this.sessionUpdater = new MicroProfileSessionMetricUpdater(enabledSessionMetrics, this.registry, (DriverContext)this.context);
        }
    }

    @VisibleForTesting
    static Duration getAndValidateEvictionTime(DriverExecutionProfile config, String logPrefix) {
        Duration evictionTime = config.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER);
        if (evictionTime.compareTo(LOWEST_ACCEPTABLE_EXPIRE_AFTER) < 0) {
            LOG.warn("[{}] Value too low for {}: {}. Forcing to {} instead.", new Object[]{logPrefix, DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER.getPath(), evictionTime, LOWEST_ACCEPTABLE_EXPIRE_AFTER});
        }
        return evictionTime;
    }

    public Optional<Metrics> getMetrics() {
        throw new UnsupportedOperationException("getMetrics() is not supported with MicroProfile. The driver publishes its metrics directly to the MetricRegistry.");
    }

    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    public NodeMetricUpdater newNodeUpdater(Node node) {
        if (this.registry == null) {
            return NoopNodeMetricUpdater.INSTANCE;
        }
        MicroProfileNodeMetricUpdater updater = new MicroProfileNodeMetricUpdater(node, this.enabledNodeMetrics, this.registry, (DriverContext)this.context, () -> {
            MicroProfileNodeMetricUpdater cfr_ignored_0 = (MicroProfileNodeMetricUpdater)this.metricsCache.getIfPresent((Object)node);
        });
        this.metricsCache.put((Object)node, (Object)updater);
        return updater;
    }
}

