/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricUpdater;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MicroProfileNodeMetricUpdater
extends MicroProfileMetricUpdater<NodeMetric>
implements NodeMetricUpdater {
    private final String metricNamePrefix;
    private final Runnable signalMetricUpdated;

    public MicroProfileNodeMetricUpdater(Node node, Set<NodeMetric> enabledMetrics, MetricRegistry registry, DriverContext driverContext, Runnable signalMetricUpdated) {
        super(enabledMetrics, registry);
        this.signalMetricUpdated = signalMetricUpdated;
        InternalDriverContext context = (InternalDriverContext)driverContext;
        this.metricNamePrefix = this.buildPrefix(driverContext.getSessionName(), node.getEndPoint());
        DriverExecutionProfile config = driverContext.getConfig().getDefaultProfile();
        if (enabledMetrics.contains(DefaultNodeMetric.OPEN_CONNECTIONS)) {
            this.registry.register(this.buildFullName((NodeMetric)DefaultNodeMetric.OPEN_CONNECTIONS, (String)null), (Metric)((Gauge)() -> ((Node)node).getOpenConnections()));
        }
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.AVAILABLE_STREAMS, node, ChannelPool::getAvailableIds, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.IN_FLIGHT, node, ChannelPool::getInFlight, context);
        this.initializePoolGauge((NodeMetric)DefaultNodeMetric.ORPHANED_STREAMS, node, ChannelPool::getOrphanedIds, context);
        this.initializeTimer(DefaultNodeMetric.CQL_MESSAGES, config);
        this.initializeDefaultCounter(DefaultNodeMetric.UNSENT_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.ABORTED_REQUESTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.WRITE_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.READ_TIMEOUTS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.UNAVAILABLES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.OTHER_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_ABORTED, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_UNAVAILABLE, null);
        this.initializeDefaultCounter(DefaultNodeMetric.IGNORES_ON_OTHER_ERROR, null);
        this.initializeDefaultCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.CONNECTION_INIT_ERRORS, null);
        this.initializeDefaultCounter(DefaultNodeMetric.AUTHENTICATION_ERRORS, null);
        this.initializeTimer(DseNodeMetric.GRAPH_MESSAGES, driverContext.getConfig().getDefaultProfile());
    }

    @Override
    public String buildFullName(NodeMetric metric, String profileName) {
        return this.metricNamePrefix + metric.getPath();
    }

    private String buildPrefix(String sessionName, EndPoint endPoint) {
        return sessionName + ".nodes." + endPoint.asMetricPrefix() + ".";
    }

    @Override
    public void incrementCounter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.incrementCounter(metric, profileName, amount);
    }

    @Override
    public void updateHistogram(NodeMetric metric, String profileName, long value) {
        this.signalMetricUpdated.run();
        super.updateHistogram(metric, profileName, value);
    }

    @Override
    public void markMeter(NodeMetric metric, String profileName, long amount) {
        this.signalMetricUpdated.run();
        super.markMeter(metric, profileName, amount);
    }

    @Override
    public void updateTimer(NodeMetric metric, String profileName, long duration, TimeUnit unit) {
        this.signalMetricUpdated.run();
        super.updateTimer(metric, profileName, duration, unit);
    }

    private void initializePoolGauge(NodeMetric metric, Node node, Function<ChannelPool, Integer> reading, InternalDriverContext context) {
        if (this.enabledMetrics.contains(metric)) {
            this.registry.register(this.buildFullName(metric, (String)null), (Metric)((Gauge)() -> {
                ChannelPool pool = (ChannelPool)context.getPoolManager().getPools().get(node);
                return pool == null ? 0 : (Integer)reading.apply(pool);
            }));
        }
    }

    public void cleanupNodeMetrics() {
        this.registry.removeMatching((id, metric) -> id.getName().startsWith(this.metricNamePrefix));
    }
}

