/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.metrics.MetricUpdater;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ThreadSafe
public abstract class MicroProfileMetricUpdater<MetricT>
implements MetricUpdater<MetricT> {
    protected final Set<MetricT> enabledMetrics;
    protected final MetricRegistry registry;

    protected MicroProfileMetricUpdater(Set<MetricT> enabledMetrics, MetricRegistry registry) {
        this.enabledMetrics = enabledMetrics;
        this.registry = registry;
    }

    protected abstract String buildFullName(MetricT var1, String var2);

    public void incrementCounter(MetricT metric, String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.counter(this.buildFullName(metric, profileName)).inc(amount);
        }
    }

    public void updateHistogram(MetricT metric, String profileName, long value) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.histogram(this.buildFullName(metric, profileName)).update(value);
        }
    }

    public void markMeter(MetricT metric, String profileName, long amount) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.meter(this.buildFullName(metric, profileName)).mark(amount);
        }
    }

    public void updateTimer(MetricT metric, String profileName, long duration, TimeUnit unit) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.timer(this.buildFullName(metric, profileName)).update(duration, unit);
        }
    }

    public boolean isEnabled(MetricT metric, String profileName) {
        return this.enabledMetrics.contains(metric);
    }

    protected void initializeDefaultCounter(MetricT metric, String profileName) {
        if (this.isEnabled(metric, profileName)) {
            this.registry.counter(this.buildFullName(metric, profileName));
        }
    }

    protected void initializeTimer(MetricT metric, DriverExecutionProfile config) {
        String profileName = config.getName();
        if (this.isEnabled(metric, profileName)) {
            String fullName = this.buildFullName(metric, profileName);
            this.registry.timer(fullName);
        }
    }
}

