/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.entity;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.annotations.DaoFactory;
import com.datastax.oss.driver.api.mapper.annotations.DaoKeyspace;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import com.datastax.oss.driver.internal.core.util.CollectionsUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class EntityHelperBase<EntityT>
implements EntityHelper<EntityT> {
    protected final CqlIdentifier keyspaceId;
    protected final CqlIdentifier tableId;
    protected final MapperContext context;

    protected EntityHelperBase(MapperContext context, String defaultTableName) {
        this(context, null, defaultTableName);
    }

    protected EntityHelperBase(MapperContext context, String defaultKeyspaceName, String defaultTableName) {
        this.context = context;
        CqlIdentifier cqlIdentifier = this.tableId = context.getTableId() != null ? context.getTableId() : CqlIdentifier.fromCql((String)defaultTableName);
        this.keyspaceId = context.getKeyspaceId() != null ? context.getKeyspaceId() : (defaultKeyspaceName == null ? null : CqlIdentifier.fromCql((String)defaultKeyspaceName));
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @Override
    @NonNull
    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    public void throwIfKeyspaceMissing() {
        if (this.getKeyspaceId() == null && !this.context.getSession().getKeyspace().isPresent()) {
            throw new MapperException(String.format("Missing keyspace. Suggestions: use SessionBuilder.withKeyspace() when creating your session, specify a default keyspace on %s with @%s(defaultKeyspace), or use a @%s method with a @%s parameter", this.getEntityClass().getSimpleName(), Entity.class.getSimpleName(), DaoFactory.class.getSimpleName(), DaoKeyspace.class.getSimpleName()));
        }
    }

    public List<CqlIdentifier> findMissingColumns(List<CqlIdentifier> entityColumns, Collection<ColumnMetadata> cqlColumns) {
        return this.findMissingCqlIdentifiers(entityColumns, cqlColumns.stream().map(ColumnMetadata::getName).collect(Collectors.toList()));
    }

    public List<CqlIdentifier> findMissingCqlIdentifiers(List<CqlIdentifier> entityColumns, Collection<CqlIdentifier> cqlColumns) {
        ArrayList<CqlIdentifier> missingColumns = new ArrayList<CqlIdentifier>();
        for (CqlIdentifier entityCqlIdentifier : entityColumns) {
            if (cqlColumns.contains(entityCqlIdentifier)) continue;
            missingColumns.add(entityCqlIdentifier);
        }
        return missingColumns;
    }

    public abstract void validateEntityFields();

    public static List<String> findTypeMismatches(Map<CqlIdentifier, GenericType<?>> entityColumns, Map<CqlIdentifier, ColumnMetadata> cqlColumns, CodecRegistry codecRegistry) {
        Map<CqlIdentifier, DataType> cqlColumnsDataTypes = cqlColumns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, cqlIdentifierColumnMetadataEntry -> ((ColumnMetadata)cqlIdentifierColumnMetadataEntry.getValue()).getType()));
        return EntityHelperBase.findDataTypeMismatches(entityColumns, cqlColumnsDataTypes, codecRegistry);
    }

    public static List<String> findTypeMismatches(Map<CqlIdentifier, GenericType<?>> entityColumns, List<CqlIdentifier> cqlColumns, List<DataType> cqlTypes, CodecRegistry codecRegistry) {
        return EntityHelperBase.findDataTypeMismatches(entityColumns, CollectionsUtils.combineListsIntoOrderedMap(cqlColumns, cqlTypes), codecRegistry);
    }

    private static List<String> findDataTypeMismatches(Map<CqlIdentifier, GenericType<?>> entityColumns, Map<CqlIdentifier, DataType> cqlColumns, CodecRegistry codecRegistry) {
        ArrayList<String> missingCodecs = new ArrayList<String>();
        for (Map.Entry<CqlIdentifier, GenericType<?>> entityEntry : entityColumns.entrySet()) {
            DataType datType = cqlColumns.get(entityEntry.getKey());
            if (datType == null) {
                throw new AssertionError((Object)("There is no cql column for entity column: " + entityEntry.getKey()));
            }
            try {
                codecRegistry.codecFor(datType, entityEntry.getValue());
            }
            catch (CodecNotFoundException exception) {
                missingCodecs.add(String.format("Field: %s, Entity Type: %s, CQL type: %s", entityEntry.getKey(), exception.getJavaType(), exception.getCqlType()));
            }
        }
        return missingCodecs;
    }

    public void throwMissingUdtTypesIfNotEmpty(List<String> missingTypes, CqlIdentifier keyspaceId, CqlIdentifier tableId, String entityClassName) {
        this.throwMissingTypesIfNotEmpty(missingTypes, keyspaceId, tableId, entityClassName, "udt");
    }

    public void throwMissingTableTypesIfNotEmpty(List<String> missingTypes, CqlIdentifier keyspaceId, CqlIdentifier tableId, String entityClassName) {
        this.throwMissingTypesIfNotEmpty(missingTypes, keyspaceId, tableId, entityClassName, "table");
    }

    public void throwMissingTypesIfNotEmpty(List<String> missingTypes, CqlIdentifier keyspaceId, CqlIdentifier tableId, String entityClassName, String type) {
        if (!missingTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format("The CQL ks.%s: %s.%s defined in the entity class: %s declares type mappings that are not supported by the codec registry:\n%s", type, keyspaceId, tableId, entityClassName, String.join((CharSequence)"\n", missingTypes)));
        }
    }

    public boolean keyspaceNamePresent(Map<CqlIdentifier, KeyspaceMetadata> keyspaces, CqlIdentifier keyspaceId) {
        return keyspaces.keySet().contains(keyspaceId);
    }
}

