/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.DefaultNullSavingStrategy;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.datastax.oss.driver.api.mapper.annotations.SetEntity;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.Classes;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class NullSavingStrategyValidation {
    private final Classes classUtils;

    public NullSavingStrategyValidation(ProcessorContext context) {
        this.classUtils = context.getClassUtils();
    }

    public boolean hasDoNotSetOnAnyLevel(List<ExecutableElement> methodElements, @Nullable DefaultNullSavingStrategy annotation) {
        boolean anyMethodHasOrDefaultsToDoNotSet = methodElements.stream().anyMatch(v -> this.updateHasDoNotSet((ExecutableElement)v, false) || this.insertHasDoNotSet((ExecutableElement)v, false) || this.setEntityHasDoNotSet((ExecutableElement)v, false) || this.queryHasDoNotSet((ExecutableElement)v, false));
        boolean anyMethodHasDoNotSetExplicitly = methodElements.stream().anyMatch(v -> this.updateHasDoNotSet((ExecutableElement)v, true) || this.insertHasDoNotSet((ExecutableElement)v, true) || this.setEntityHasDoNotSet((ExecutableElement)v, true) || this.queryHasDoNotSet((ExecutableElement)v, true));
        boolean allMethodsHaveSetToNull = methodElements.stream().filter(this::isOperationWithNullSavingStrategy).allMatch(v -> this.updateHasSetToNullExplicitly((ExecutableElement)v) || this.insertHasSetToNullExplicitly((ExecutableElement)v) || this.setEntitySetToNullExplicitly((ExecutableElement)v) || this.queryHasSetToNullExplicitly((ExecutableElement)v));
        if (this.daoHasSetToNull(annotation) && anyMethodHasDoNotSetExplicitly) {
            return true;
        }
        if (this.daoHasDoNotSet(annotation) && !allMethodsHaveSetToNull) {
            return true;
        }
        return this.daoIsNotAnnotated(annotation) && anyMethodHasOrDefaultsToDoNotSet;
    }

    private boolean daoHasDoNotSet(DefaultNullSavingStrategy annotation) {
        if (annotation != null) {
            return annotation.value() == NullSavingStrategy.DO_NOT_SET;
        }
        return false;
    }

    private boolean daoHasSetToNull(DefaultNullSavingStrategy annotation) {
        if (annotation != null) {
            return annotation.value() == NullSavingStrategy.SET_TO_NULL;
        }
        return false;
    }

    private boolean daoIsNotAnnotated(DefaultNullSavingStrategy annotation) {
        return annotation == null;
    }

    private boolean queryHasDoNotSet(ExecutableElement v, boolean explicitSet) {
        return this.hasDoNotSet(Query.class, Query::nullSavingStrategy, v, explicitSet);
    }

    private boolean setEntityHasDoNotSet(ExecutableElement v, boolean explicitSet) {
        return this.hasDoNotSet(SetEntity.class, SetEntity::nullSavingStrategy, v, explicitSet);
    }

    private boolean insertHasDoNotSet(ExecutableElement v, boolean explicitSet) {
        return this.hasDoNotSet(Insert.class, Insert::nullSavingStrategy, v, explicitSet);
    }

    private boolean updateHasDoNotSet(ExecutableElement v, boolean explicitSet) {
        return this.hasDoNotSet(Update.class, Update::nullSavingStrategy, v, explicitSet);
    }

    private <A extends Annotation> boolean hasDoNotSet(Class<A> clazz, Function<A, NullSavingStrategy> extractor, ExecutableElement v, boolean explicitSet) {
        A annotation = v.getAnnotation(clazz);
        if (annotation != null) {
            NullSavingStrategy strategy = extractor.apply(annotation);
            if (explicitSet) {
                return strategy == NullSavingStrategy.DO_NOT_SET && this.nullSavingStrategyExplicitlySet(v, clazz);
            }
            return strategy == NullSavingStrategy.DO_NOT_SET;
        }
        return false;
    }

    private boolean queryHasSetToNullExplicitly(ExecutableElement v) {
        return this.hadSetToNullExplicitly(Query.class, Query::nullSavingStrategy, v);
    }

    private boolean setEntitySetToNullExplicitly(ExecutableElement v) {
        return this.hadSetToNullExplicitly(SetEntity.class, SetEntity::nullSavingStrategy, v);
    }

    private boolean insertHasSetToNullExplicitly(ExecutableElement v) {
        return this.hadSetToNullExplicitly(Insert.class, Insert::nullSavingStrategy, v);
    }

    private boolean updateHasSetToNullExplicitly(ExecutableElement v) {
        return this.hadSetToNullExplicitly(Update.class, Update::nullSavingStrategy, v);
    }

    private <A extends Annotation> boolean hadSetToNullExplicitly(Class<A> clazz, Function<A, NullSavingStrategy> extractor, ExecutableElement v) {
        A annotation = v.getAnnotation(clazz);
        if (annotation != null) {
            NullSavingStrategy strategy = extractor.apply(annotation);
            return strategy == NullSavingStrategy.SET_TO_NULL && this.nullSavingStrategyExplicitlySet(v, clazz);
        }
        return false;
    }

    private boolean isOperationWithNullSavingStrategy(ExecutableElement v) {
        return v.getAnnotation(Update.class) != null || v.getAnnotation(Insert.class) != null || v.getAnnotation(SetEntity.class) != null || v.getAnnotation(Query.class) != null;
    }

    private boolean nullSavingStrategyExplicitlySet(Element methodElement, Class<?> javaClass) {
        Optional<AnnotationMirror> annotationMirrorForJavaClass = this.getAnnotationMirrorForJavaClass(methodElement, javaClass);
        if (annotationMirrorForJavaClass.isPresent()) {
            for (ExecutableElement executableElement : annotationMirrorForJavaClass.get().getElementValues().keySet()) {
                if (!executableElement.getSimpleName().contentEquals("nullSavingStrategy")) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<AnnotationMirror> getAnnotationMirrorForJavaClass(Element methodElement, Class<?> javaClass) {
        List<? extends AnnotationMirror> annotationMirrors = methodElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!this.classUtils.isSame(annotationMirror.getAnnotationType(), javaClass)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public <A extends Annotation> NullSavingStrategy getNullSavingStrategy(Class<A> clazz, Function<A, NullSavingStrategy> extractor, ExecutableElement methodElement, DaoImplementationSharedCode daoClass) {
        A annotation = methodElement.getAnnotation(clazz);
        Optional<NullSavingStrategy> daoNullSavingStrategy = daoClass.getNullSavingStrategy();
        boolean methodNullSavingStrategyExplicitlySet = this.nullSavingStrategyExplicitlySet(methodElement, clazz);
        if (methodNullSavingStrategyExplicitlySet || !daoNullSavingStrategy.isPresent()) {
            return extractor.apply(annotation);
        }
        return daoNullSavingStrategy.get();
    }
}

