/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util.generation;

import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class GenericTypeConstantGenerator {
    private final NameIndex nameIndex;
    private final Map<TypeName, String> typeConstantNames = new LinkedHashMap<TypeName, String>();

    public GenericTypeConstantGenerator(NameIndex nameIndex) {
        this.nameIndex = nameIndex;
    }

    public String add(TypeName type) {
        return this.typeConstantNames.computeIfAbsent(type, k -> this.nameIndex.uniqueField("GENERIC_TYPE"));
    }

    public void generate(TypeSpec.Builder classBuilder) {
        for (Map.Entry<TypeName, String> entry : this.typeConstantNames.entrySet()) {
            TypeName typeParameter = entry.getKey();
            String name = entry.getValue();
            ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)ClassName.get(GenericType.class), (TypeName[])new TypeName[]{typeParameter});
            classBuilder.addField(FieldSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(){}", new Object[]{type}).build());
        }
    }
}

