/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util;

import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.SettableByName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Classes {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeMirror settableByNameType;
    private final TypeMirror gettableByNameType;
    private final TypeElement listElement;
    private final TypeElement setElement;
    private final TypeElement mapElement;
    private final TypeElement completionStageElement;
    private final TypeElement completableFutureElement;

    public Classes(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.settableByNameType = typeUtils.erasure(elementUtils.getTypeElement(SettableByName.class.getName()).asType());
        this.gettableByNameType = typeUtils.erasure(elementUtils.getTypeElement(GettableByName.class.getName()).asType());
        this.listElement = elementUtils.getTypeElement(List.class.getCanonicalName());
        this.setElement = elementUtils.getTypeElement(Set.class.getCanonicalName());
        this.mapElement = elementUtils.getTypeElement(Map.class.getCanonicalName());
        this.completionStageElement = elementUtils.getTypeElement(CompletionStage.class.getCanonicalName());
        this.completableFutureElement = elementUtils.getTypeElement(CompletableFuture.class.getCanonicalName());
    }

    public boolean isSame(Element element, Class<?> javaClass) {
        return element.equals(this.elementUtils.getTypeElement(javaClass.getName()));
    }

    public boolean isSame(TypeMirror mirror, Class<?> javaClass) {
        return this.typeUtils.isSameType(mirror, this.elementUtils.getTypeElement(javaClass.getName()).asType());
    }

    public boolean implementsSettableByName(TypeMirror mirror) {
        return this.typeUtils.isAssignable(mirror, this.settableByNameType);
    }

    public boolean implementsGettableByName(TypeMirror mirror) {
        return this.typeUtils.isAssignable(mirror, this.gettableByNameType);
    }

    public boolean isList(DeclaredType declaredType) {
        return declaredType.asElement().equals(this.listElement);
    }

    public boolean isSet(DeclaredType declaredType) {
        return declaredType.asElement().equals(this.setElement);
    }

    public boolean isMap(DeclaredType declaredType) {
        return declaredType.asElement().equals(this.mapElement);
    }

    public boolean isFuture(DeclaredType declaredType) {
        return declaredType.asElement().equals(this.completionStageElement) || declaredType.asElement().equals(this.completableFutureElement);
    }
}

