/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.InsightsClientLifecycleListener;
import com.datastax.dse.driver.internal.core.type.codec.DseTypeCodecsRegistrar;
import com.datastax.dse.protocol.internal.DseProtocolV1ClientCodecs;
import com.datastax.dse.protocol.internal.DseProtocolV2ClientCodecs;
import com.datastax.dse.protocol.internal.ProtocolV4ClientCodecsForDse;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistanceEvaluator;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.api.core.time.TimestampGenerator;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.internal.core.ConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.DefaultConsistencyLevelRegistry;
import com.datastax.oss.driver.internal.core.DefaultProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.DefaultWriteCoalescer;
import com.datastax.oss.driver.internal.core.channel.WriteCoalescer;
import com.datastax.oss.driver.internal.core.context.DefaultNettyOptions;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.LifecycleListener;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.context.StartupOptionsBuilder;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.CloudTopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.DefaultTopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.MultiplexingNodeStateListener;
import com.datastax.oss.driver.internal.core.metadata.NoopNodeStateListener;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.schema.MultiplexingSchemaChangeListener;
import com.datastax.oss.driver.internal.core.metadata.schema.NoopSchemaChangeListener;
import com.datastax.oss.driver.internal.core.metadata.schema.TabletMapSchemaChangeListener;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DefaultSchemaParserFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.DefaultSchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenFactoryRegistry;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactoryRegistry;
import com.datastax.oss.driver.internal.core.metrics.MetricIdGenerator;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolFactory;
import com.datastax.oss.driver.internal.core.protocol.BuiltInCompressors;
import com.datastax.oss.driver.internal.core.protocol.ByteBufPrimitiveCodec;
import com.datastax.oss.driver.internal.core.servererrors.DefaultWriteTypeRegistry;
import com.datastax.oss.driver.internal.core.servererrors.WriteTypeRegistry;
import com.datastax.oss.driver.internal.core.session.BuiltInRequestProcessors;
import com.datastax.oss.driver.internal.core.session.PoolManager;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.internal.core.session.RequestProcessorRegistry;
import com.datastax.oss.driver.internal.core.ssl.JdkSslHandlerFactory;
import com.datastax.oss.driver.internal.core.ssl.SslHandlerFactory;
import com.datastax.oss.driver.internal.core.tracker.MultiplexingRequestTracker;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.tracker.RequestLogFormatter;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.driver.internal.core.util.DefaultDependencyChecker;
import com.datastax.oss.driver.internal.core.util.Dependency;
import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.driver.internal.core.util.concurrent.CycleDetector;
import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolV3ClientCodecs;
import com.datastax.oss.protocol.internal.ProtocolV5ClientCodecs;
import com.datastax.oss.protocol.internal.ProtocolV6ClientCodecs;
import com.datastax.oss.protocol.internal.SegmentCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultDriverContext
implements InternalDriverContext {
    private static final Logger LOG = LoggerFactory.getLogger(InternalDriverContext.class);
    private static final AtomicInteger SESSION_NAME_COUNTER = new AtomicInteger();
    protected final CycleDetector cycleDetector = new CycleDetector("Detected cycle in context initialization");
    private final LazyReference<Map<String, LoadBalancingPolicy>> loadBalancingPoliciesRef = new LazyReference<Map>("loadBalancingPolicies", this::buildLoadBalancingPolicies, this.cycleDetector);
    private final LazyReference<ReconnectionPolicy> reconnectionPolicyRef = new LazyReference<ReconnectionPolicy>("reconnectionPolicy", this::buildReconnectionPolicy, this.cycleDetector);
    private final LazyReference<Map<String, RetryPolicy>> retryPoliciesRef = new LazyReference<Map>("retryPolicies", this::buildRetryPolicies, this.cycleDetector);
    private final LazyReference<Map<String, SpeculativeExecutionPolicy>> speculativeExecutionPoliciesRef = new LazyReference<Map>("speculativeExecutionPolicies", this::buildSpeculativeExecutionPolicies, this.cycleDetector);
    private final LazyReference<TimestampGenerator> timestampGeneratorRef = new LazyReference<TimestampGenerator>("timestampGenerator", this::buildTimestampGenerator, this.cycleDetector);
    private final LazyReference<AddressTranslator> addressTranslatorRef = new LazyReference<AddressTranslator>("addressTranslator", this::buildAddressTranslator, this.cycleDetector);
    private final LazyReference<Optional<SslEngineFactory>> sslEngineFactoryRef;
    private final LazyReference<EventBus> eventBusRef = new LazyReference<EventBus>("eventBus", this::buildEventBus, this.cycleDetector);
    private final LazyReference<Compressor<ByteBuf>> compressorRef = new LazyReference<Compressor>("compressor", this::buildCompressor, this.cycleDetector);
    private final LazyReference<PrimitiveCodec<ByteBuf>> primitiveCodecRef = new LazyReference<PrimitiveCodec>("primitiveCodec", this::buildPrimitiveCodec, this.cycleDetector);
    private final LazyReference<FrameCodec<ByteBuf>> frameCodecRef = new LazyReference<FrameCodec>("frameCodec", this::buildFrameCodec, this.cycleDetector);
    private final LazyReference<SegmentCodec<ByteBuf>> segmentCodecRef = new LazyReference<SegmentCodec>("segmentCodec", this::buildSegmentCodec, this.cycleDetector);
    private final LazyReference<ProtocolVersionRegistry> protocolVersionRegistryRef = new LazyReference<ProtocolVersionRegistry>("protocolVersionRegistry", this::buildProtocolVersionRegistry, this.cycleDetector);
    private final LazyReference<ConsistencyLevelRegistry> consistencyLevelRegistryRef = new LazyReference<ConsistencyLevelRegistry>("consistencyLevelRegistry", this::buildConsistencyLevelRegistry, this.cycleDetector);
    private final LazyReference<WriteTypeRegistry> writeTypeRegistryRef = new LazyReference<WriteTypeRegistry>("writeTypeRegistry", this::buildWriteTypeRegistry, this.cycleDetector);
    private final LazyReference<NettyOptions> nettyOptionsRef = new LazyReference<NettyOptions>("nettyOptions", this::buildNettyOptions, this.cycleDetector);
    private final LazyReference<WriteCoalescer> writeCoalescerRef = new LazyReference<WriteCoalescer>("writeCoalescer", this::buildWriteCoalescer, this.cycleDetector);
    private final LazyReference<Optional<SslHandlerFactory>> sslHandlerFactoryRef = new LazyReference<Optional>("sslHandlerFactory", this::buildSslHandlerFactory, this.cycleDetector);
    private final LazyReference<ChannelFactory> channelFactoryRef = new LazyReference<ChannelFactory>("channelFactory", this::buildChannelFactory, this.cycleDetector);
    private final LazyReference<TopologyMonitor> topologyMonitorRef = new LazyReference<TopologyMonitor>("topologyMonitor", this::buildTopologyMonitor, this.cycleDetector);
    private final LazyReference<MetadataManager> metadataManagerRef = new LazyReference<MetadataManager>("metadataManager", this::buildMetadataManager, this.cycleDetector);
    private final LazyReference<LoadBalancingPolicyWrapper> loadBalancingPolicyWrapperRef = new LazyReference<LoadBalancingPolicyWrapper>("loadBalancingPolicyWrapper", this::buildLoadBalancingPolicyWrapper, this.cycleDetector);
    private final LazyReference<ControlConnection> controlConnectionRef = new LazyReference<ControlConnection>("controlConnection", this::buildControlConnection, this.cycleDetector);
    private final LazyReference<RequestProcessorRegistry> requestProcessorRegistryRef = new LazyReference<RequestProcessorRegistry>("requestProcessorRegistry", this::buildRequestProcessorRegistry, this.cycleDetector);
    private final LazyReference<SchemaQueriesFactory> schemaQueriesFactoryRef = new LazyReference<SchemaQueriesFactory>("schemaQueriesFactory", this::buildSchemaQueriesFactory, this.cycleDetector);
    private final LazyReference<SchemaParserFactory> schemaParserFactoryRef = new LazyReference<SchemaParserFactory>("schemaParserFactory", this::buildSchemaParserFactory, this.cycleDetector);
    private final LazyReference<TokenFactoryRegistry> tokenFactoryRegistryRef = new LazyReference<TokenFactoryRegistry>("tokenFactoryRegistry", this::buildTokenFactoryRegistry, this.cycleDetector);
    private final LazyReference<ReplicationStrategyFactory> replicationStrategyFactoryRef = new LazyReference<ReplicationStrategyFactory>("replicationStrategyFactory", this::buildReplicationStrategyFactory, this.cycleDetector);
    private final LazyReference<PoolManager> poolManagerRef = new LazyReference<PoolManager>("poolManager", this::buildPoolManager, this.cycleDetector);
    private final LazyReference<MetricsFactory> metricsFactoryRef = new LazyReference<MetricsFactory>("metricsFactory", this::buildMetricsFactory, this.cycleDetector);
    private final LazyReference<MetricIdGenerator> metricIdGeneratorRef = new LazyReference<MetricIdGenerator>("metricIdGenerator", this::buildMetricIdGenerator, this.cycleDetector);
    private final LazyReference<RequestThrottler> requestThrottlerRef = new LazyReference<RequestThrottler>("requestThrottler", this::buildRequestThrottler, this.cycleDetector);
    private final LazyReference<Map<String, String>> startupOptionsRef = new LazyReference<Map>("startupOptions", this::buildStartupOptions, this.cycleDetector);
    private final LazyReference<NodeStateListener> nodeStateListenerRef;
    private final LazyReference<SchemaChangeListener> schemaChangeListenerRef;
    private final LazyReference<RequestTracker> requestTrackerRef;
    private final LazyReference<Optional<AuthProvider>> authProviderRef;
    private final LazyReference<List<LifecycleListener>> lifecycleListenersRef = new LazyReference<List>("lifecycleListeners", this::buildLifecycleListeners, this.cycleDetector);
    private final DriverConfig config;
    private final DriverConfigLoader configLoader;
    private final ChannelPoolFactory channelPoolFactory = new ChannelPoolFactory();
    private final CodecRegistry codecRegistry;
    private final String sessionName;
    private final NodeStateListener nodeStateListenerFromBuilder;
    private final SchemaChangeListener schemaChangeListenerFromBuilder;
    private final RequestTracker requestTrackerFromBuilder;
    private final Map<String, String> localDatacentersFromBuilder;
    private final Map<String, Predicate<Node>> nodeFiltersFromBuilder;
    private final Map<String, NodeDistanceEvaluator> nodeDistanceEvaluatorsFromBuilder;
    private final ClassLoader classLoader;
    private final InetSocketAddress cloudProxyAddress;
    private final LazyReference<RequestLogFormatter> requestLogFormatterRef = new LazyReference<RequestLogFormatter>("requestLogFormatter", this::buildRequestLogFormatter, this.cycleDetector);
    private final UUID startupClientId;
    private final String startupApplicationName;
    private final String startupApplicationVersion;
    private final Object metricRegistry;
    private final StackTraceElement[] initStackTrace;

    public DefaultDriverContext(DriverConfigLoader configLoader, ProgrammaticArguments programmaticArguments) {
        StackTraceElement[] stackTrace;
        this.config = configLoader.getInitialConfig();
        this.configLoader = configLoader;
        DriverExecutionProfile defaultProfile = this.config.getDefaultProfile();
        this.sessionName = defaultProfile.isDefined(DefaultDriverOption.SESSION_NAME) ? defaultProfile.getString(DefaultDriverOption.SESSION_NAME) : "s" + SESSION_NAME_COUNTER.getAndIncrement();
        this.localDatacentersFromBuilder = programmaticArguments.getLocalDatacenters();
        this.codecRegistry = this.buildCodecRegistry(programmaticArguments);
        this.nodeStateListenerFromBuilder = programmaticArguments.getNodeStateListener();
        this.nodeStateListenerRef = new LazyReference<NodeStateListener>("nodeStateListener", () -> this.buildNodeStateListener(this.nodeStateListenerFromBuilder), this.cycleDetector);
        this.schemaChangeListenerFromBuilder = programmaticArguments.getSchemaChangeListener();
        this.schemaChangeListenerRef = new LazyReference<SchemaChangeListener>("schemaChangeListener", () -> this.buildSchemaChangeListener(this.schemaChangeListenerFromBuilder), this.cycleDetector);
        this.requestTrackerFromBuilder = programmaticArguments.getRequestTracker();
        this.authProviderRef = new LazyReference<Optional>("authProvider", () -> this.buildAuthProvider(programmaticArguments.getAuthProvider()), this.cycleDetector);
        this.requestTrackerRef = new LazyReference<RequestTracker>("requestTracker", () -> this.buildRequestTracker(this.requestTrackerFromBuilder), this.cycleDetector);
        this.sslEngineFactoryRef = new LazyReference<Optional>("sslEngineFactory", () -> this.buildSslEngineFactory(programmaticArguments.getSslEngineFactory()), this.cycleDetector);
        Map<String, Predicate<Node>> nodeFilters = programmaticArguments.getNodeFilters();
        this.nodeFiltersFromBuilder = nodeFilters;
        this.nodeDistanceEvaluatorsFromBuilder = programmaticArguments.getNodeDistanceEvaluators();
        this.classLoader = programmaticArguments.getClassLoader();
        this.cloudProxyAddress = programmaticArguments.getCloudProxyAddress();
        this.startupClientId = programmaticArguments.getStartupClientId();
        this.startupApplicationName = programmaticArguments.getStartupApplicationName();
        this.startupApplicationVersion = programmaticArguments.getStartupApplicationVersion();
        try {
            stackTrace = Thread.currentThread().getStackTrace();
        }
        catch (Exception ex) {
            stackTrace = new StackTraceElement[]{};
        }
        this.initStackTrace = stackTrace;
        this.metricRegistry = programmaticArguments.getMetricRegistry();
    }

    @Deprecated
    public DefaultDriverContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader) {
        this(configLoader, ProgrammaticArguments.builder().addTypeCodecs(typeCodecs.toArray(new TypeCodec[0])).withNodeStateListener(nodeStateListener).withSchemaChangeListener(schemaChangeListener).withRequestTracker(requestTracker).withLocalDatacenters(localDatacenters).withNodeFilters(nodeFilters).withClassLoader(classLoader).build());
    }

    protected Map<String, String> buildStartupOptions() {
        return new StartupOptionsBuilder(this).withClientId(this.startupClientId).withApplicationName(this.startupApplicationName).withApplicationVersion(this.startupApplicationVersion).build();
    }

    protected Map<String, LoadBalancingPolicy> buildLoadBalancingPolicies() {
        return Reflection.buildFromConfigProfiles(this, DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, DefaultDriverOption.LOAD_BALANCING_POLICY, LoadBalancingPolicy.class, "com.datastax.oss.driver.internal.core.loadbalancing", "com.datastax.dse.driver.internal.core.loadbalancing");
    }

    protected Map<String, RetryPolicy> buildRetryPolicies() {
        return Reflection.buildFromConfigProfiles(this, DefaultDriverOption.RETRY_POLICY_CLASS, DefaultDriverOption.RETRY_POLICY, RetryPolicy.class, "com.datastax.oss.driver.internal.core.retry");
    }

    protected Map<String, SpeculativeExecutionPolicy> buildSpeculativeExecutionPolicies() {
        return Reflection.buildFromConfigProfiles(this, DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY, SpeculativeExecutionPolicy.class, "com.datastax.oss.driver.internal.core.specex");
    }

    protected TimestampGenerator buildTimestampGenerator() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.TIMESTAMP_GENERATOR_CLASS, TimestampGenerator.class, "com.datastax.oss.driver.internal.core.time").orElseThrow(() -> new IllegalArgumentException(String.format("Missing timestamp generator, check your configuration (%s)", DefaultDriverOption.TIMESTAMP_GENERATOR_CLASS)));
    }

    protected ReconnectionPolicy buildReconnectionPolicy() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.RECONNECTION_POLICY_CLASS, ReconnectionPolicy.class, "com.datastax.oss.driver.internal.core.connection").orElseThrow(() -> new IllegalArgumentException(String.format("Missing reconnection policy, check your configuration (%s)", DefaultDriverOption.RECONNECTION_POLICY_CLASS)));
    }

    protected AddressTranslator buildAddressTranslator() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS, AddressTranslator.class, "com.datastax.oss.driver.internal.core.addresstranslation").orElseThrow(() -> new IllegalArgumentException(String.format("Missing address translator, check your configuration (%s)", DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS)));
    }

    protected Optional<SslEngineFactory> buildSslEngineFactory(SslEngineFactory factoryFromBuilder) {
        return factoryFromBuilder != null ? Optional.of(factoryFromBuilder) : Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, SslEngineFactory.class, "com.datastax.oss.driver.internal.core.ssl");
    }

    protected EventBus buildEventBus() {
        return new EventBus(this.getSessionName());
    }

    protected Compressor<ByteBuf> buildCompressor() {
        DriverExecutionProfile defaultProfile = this.getConfig().getDefaultProfile();
        String name = defaultProfile.getString(DefaultDriverOption.PROTOCOL_COMPRESSION, "none");
        assert (name != null) : "should use default value";
        return BuiltInCompressors.newInstance(name, this);
    }

    protected PrimitiveCodec<ByteBuf> buildPrimitiveCodec() {
        return new ByteBufPrimitiveCodec(this.getNettyOptions().allocator());
    }

    protected FrameCodec<ByteBuf> buildFrameCodec() {
        return new FrameCodec(this.getPrimitiveCodec(), this.getCompressor(), new FrameCodec.CodecGroup[]{new ProtocolV3ClientCodecs(), new ProtocolV4ClientCodecsForDse(), new ProtocolV5ClientCodecs(), new ProtocolV6ClientCodecs(), new DseProtocolV1ClientCodecs(), new DseProtocolV2ClientCodecs()});
    }

    protected SegmentCodec<ByteBuf> buildSegmentCodec() {
        return new SegmentCodec(this.getPrimitiveCodec(), this.getCompressor());
    }

    protected ProtocolVersionRegistry buildProtocolVersionRegistry() {
        return new DefaultProtocolVersionRegistry(this.getSessionName());
    }

    protected ConsistencyLevelRegistry buildConsistencyLevelRegistry() {
        return new DefaultConsistencyLevelRegistry();
    }

    protected WriteTypeRegistry buildWriteTypeRegistry() {
        return new DefaultWriteTypeRegistry();
    }

    protected NettyOptions buildNettyOptions() {
        return new DefaultNettyOptions(this);
    }

    protected Optional<SslHandlerFactory> buildSslHandlerFactory() {
        return this.getSslEngineFactory().map(JdkSslHandlerFactory::new);
    }

    protected WriteCoalescer buildWriteCoalescer() {
        return new DefaultWriteCoalescer(this);
    }

    protected ChannelFactory buildChannelFactory() {
        return new ChannelFactory(this);
    }

    protected TopologyMonitor buildTopologyMonitor() {
        if (this.cloudProxyAddress == null) {
            return new DefaultTopologyMonitor(this);
        }
        return new CloudTopologyMonitor(this, this.cloudProxyAddress);
    }

    protected MetadataManager buildMetadataManager() {
        return new MetadataManager(this);
    }

    protected LoadBalancingPolicyWrapper buildLoadBalancingPolicyWrapper() {
        return new LoadBalancingPolicyWrapper(this, this.getLoadBalancingPolicies());
    }

    protected ControlConnection buildControlConnection() {
        return new ControlConnection(this);
    }

    protected RequestProcessorRegistry buildRequestProcessorRegistry() {
        List<RequestProcessor<?, ?>> processors = BuiltInRequestProcessors.createDefaultProcessors(this);
        return new RequestProcessorRegistry(this.getSessionName(), processors.toArray(new RequestProcessor[0]));
    }

    protected CodecRegistry buildCodecRegistry(ProgrammaticArguments arguments) {
        MutableCodecRegistry registry = arguments.getCodecRegistry();
        if (registry == null) {
            registry = new DefaultCodecRegistry(this.sessionName);
        }
        registry.register(arguments.getTypeCodecs());
        DseTypeCodecsRegistrar.registerDseCodecs(registry);
        return registry;
    }

    protected SchemaQueriesFactory buildSchemaQueriesFactory() {
        return new DefaultSchemaQueriesFactory(this);
    }

    protected SchemaParserFactory buildSchemaParserFactory() {
        return new DefaultSchemaParserFactory(this);
    }

    protected TokenFactoryRegistry buildTokenFactoryRegistry() {
        return new DefaultTokenFactoryRegistry(this);
    }

    protected ReplicationStrategyFactory buildReplicationStrategyFactory() {
        return new DefaultReplicationStrategyFactory(this);
    }

    protected PoolManager buildPoolManager() {
        return new PoolManager(this);
    }

    protected MetricsFactory buildMetricsFactory() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.METRICS_FACTORY_CLASS, MetricsFactory.class, "com.datastax.oss.driver.internal.core.metrics", "com.datastax.oss.driver.internal.metrics.microprofile", "com.datastax.oss.driver.internal.metrics.micrometer").orElseThrow(() -> new IllegalArgumentException(String.format("Missing metrics factory, check your config (%s)", DefaultDriverOption.METRICS_FACTORY_CLASS)));
    }

    protected MetricIdGenerator buildMetricIdGenerator() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.METRICS_ID_GENERATOR_CLASS, MetricIdGenerator.class, "com.datastax.oss.driver.internal.core.metrics").orElseThrow(() -> new IllegalArgumentException(String.format("Missing metric descriptor, check your config (%s)", DefaultDriverOption.METRICS_ID_GENERATOR_CLASS)));
    }

    protected RequestThrottler buildRequestThrottler() {
        return Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.REQUEST_THROTTLER_CLASS, RequestThrottler.class, "com.datastax.oss.driver.internal.core.session.throttling").orElseThrow(() -> new IllegalArgumentException(String.format("Missing request throttler, check your configuration (%s)", DefaultDriverOption.REQUEST_THROTTLER_CLASS)));
    }

    protected NodeStateListener buildNodeStateListener(NodeStateListener nodeStateListenerFromBuilder) {
        ArrayList<NodeStateListener> listeners = new ArrayList<NodeStateListener>();
        if (nodeStateListenerFromBuilder != null) {
            listeners.add(nodeStateListenerFromBuilder);
        }
        DefaultDriverOption newOption = DefaultDriverOption.METADATA_NODE_STATE_LISTENER_CLASSES;
        DefaultDriverOption legacyOption = DefaultDriverOption.METADATA_NODE_STATE_LISTENER_CLASS;
        DriverExecutionProfile profile = this.config.getDefaultProfile();
        if (profile.isDefined(newOption)) {
            listeners.addAll((Collection<NodeStateListener>)Reflection.buildFromConfigList((InternalDriverContext)this, newOption, NodeStateListener.class, "com.datastax.oss.driver.internal.core.metadata"));
        }
        if (profile.isDefined(legacyOption)) {
            LOG.warn("Option {} has been deprecated and will be removed in a future release; please use option {} instead.", (Object)legacyOption, (Object)newOption);
            Reflection.buildFromConfig((InternalDriverContext)this, legacyOption, NodeStateListener.class, "com.datastax.oss.driver.internal.core.metadata").ifPresent(listeners::add);
        }
        if (listeners.isEmpty()) {
            return new NoopNodeStateListener(this);
        }
        if (listeners.size() == 1) {
            return (NodeStateListener)listeners.get(0);
        }
        return new MultiplexingNodeStateListener(listeners);
    }

    protected SchemaChangeListener buildSchemaChangeListener(SchemaChangeListener schemaChangeListenerFromBuilder) {
        ArrayList<SchemaChangeListener> listeners = new ArrayList<SchemaChangeListener>();
        if (schemaChangeListenerFromBuilder != null) {
            listeners.add(schemaChangeListenerFromBuilder);
        }
        DefaultDriverOption newOption = DefaultDriverOption.METADATA_SCHEMA_CHANGE_LISTENER_CLASSES;
        DefaultDriverOption legacyOption = DefaultDriverOption.METADATA_SCHEMA_CHANGE_LISTENER_CLASS;
        DriverExecutionProfile profile = this.config.getDefaultProfile();
        if (profile.isDefined(newOption)) {
            listeners.addAll((Collection<SchemaChangeListener>)Reflection.buildFromConfigList((InternalDriverContext)this, newOption, SchemaChangeListener.class, "com.datastax.oss.driver.internal.core.metadata.schema"));
        }
        if (profile.isDefined(legacyOption)) {
            LOG.warn("Option {} has been deprecated and will be removed in a future release; please use option {} instead.", (Object)legacyOption, (Object)newOption);
            Reflection.buildFromConfig((InternalDriverContext)this, legacyOption, SchemaChangeListener.class, "com.datastax.oss.driver.internal.core.metadata.schema").ifPresent(listeners::add);
        }
        if (this.getMetadataManager().isSchemaEnabled()) {
            listeners.add(new TabletMapSchemaChangeListener(this.getMetadataManager()));
        }
        if (listeners.isEmpty()) {
            return new NoopSchemaChangeListener(this);
        }
        if (listeners.size() == 1) {
            return (SchemaChangeListener)listeners.get(0);
        }
        return new MultiplexingSchemaChangeListener(listeners);
    }

    protected RequestTracker buildRequestTracker(RequestTracker requestTrackerFromBuilder) {
        ArrayList<RequestTracker> trackers = new ArrayList<RequestTracker>();
        if (requestTrackerFromBuilder != null) {
            trackers.add(requestTrackerFromBuilder);
        }
        for (LoadBalancingPolicy lbp : this.getLoadBalancingPolicies().values()) {
            lbp.getRequestTracker().ifPresent(trackers::add);
        }
        DefaultDriverOption newOption = DefaultDriverOption.REQUEST_TRACKER_CLASSES;
        DefaultDriverOption legacyOption = DefaultDriverOption.REQUEST_TRACKER_CLASS;
        DriverExecutionProfile profile = this.config.getDefaultProfile();
        if (profile.isDefined(newOption)) {
            trackers.addAll((Collection<RequestTracker>)Reflection.buildFromConfigList((InternalDriverContext)this, newOption, RequestTracker.class, "com.datastax.oss.driver.internal.core.tracker"));
        }
        if (profile.isDefined(legacyOption)) {
            LOG.warn("Option {} has been deprecated and will be removed in a future release; please use option {} instead.", (Object)legacyOption, (Object)newOption);
            Reflection.buildFromConfig((InternalDriverContext)this, legacyOption, RequestTracker.class, "com.datastax.oss.driver.internal.core.tracker").ifPresent(trackers::add);
        }
        if (trackers.isEmpty()) {
            return new NoopRequestTracker(this);
        }
        if (trackers.size() == 1) {
            return (RequestTracker)trackers.get(0);
        }
        return new MultiplexingRequestTracker(trackers);
    }

    protected Optional<AuthProvider> buildAuthProvider(AuthProvider authProviderFromBuilder) {
        return authProviderFromBuilder != null ? Optional.of(authProviderFromBuilder) : Reflection.buildFromConfig((InternalDriverContext)this, DefaultDriverOption.AUTH_PROVIDER_CLASS, AuthProvider.class, "com.datastax.oss.driver.internal.core.auth", "com.datastax.dse.driver.internal.core.auth");
    }

    protected List<LifecycleListener> buildLifecycleListeners() {
        if (DefaultDependencyChecker.isPresent(Dependency.JACKSON)) {
            return Collections.singletonList(new InsightsClientLifecycleListener(this, this.initStackTrace));
        }
        if (this.config.getDefaultProfile().getBoolean(DseDriverOption.MONITOR_REPORTING_ENABLED)) {
            LOG.info("Could not initialize Insights monitoring; this is normal if Jackson was explicitly excluded from classpath");
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    @NonNull
    public DriverConfig getConfig() {
        return this.config;
    }

    @Override
    @NonNull
    public DriverConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    @Override
    @NonNull
    public Map<String, LoadBalancingPolicy> getLoadBalancingPolicies() {
        return this.loadBalancingPoliciesRef.get();
    }

    @Override
    @NonNull
    public Map<String, RetryPolicy> getRetryPolicies() {
        return this.retryPoliciesRef.get();
    }

    @Override
    @NonNull
    public Map<String, SpeculativeExecutionPolicy> getSpeculativeExecutionPolicies() {
        return this.speculativeExecutionPoliciesRef.get();
    }

    @Override
    @NonNull
    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGeneratorRef.get();
    }

    @Override
    @NonNull
    public ReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicyRef.get();
    }

    @Override
    @NonNull
    public AddressTranslator getAddressTranslator() {
        return this.addressTranslatorRef.get();
    }

    @Override
    @NonNull
    public Optional<AuthProvider> getAuthProvider() {
        return this.authProviderRef.get();
    }

    @Override
    @NonNull
    public Optional<SslEngineFactory> getSslEngineFactory() {
        return this.sslEngineFactoryRef.get();
    }

    @Override
    @NonNull
    public EventBus getEventBus() {
        return this.eventBusRef.get();
    }

    @Override
    @NonNull
    public Compressor<ByteBuf> getCompressor() {
        return this.compressorRef.get();
    }

    @Override
    @NonNull
    public PrimitiveCodec<ByteBuf> getPrimitiveCodec() {
        return this.primitiveCodecRef.get();
    }

    @Override
    @NonNull
    public FrameCodec<ByteBuf> getFrameCodec() {
        return this.frameCodecRef.get();
    }

    @Override
    @NonNull
    public SegmentCodec<ByteBuf> getSegmentCodec() {
        return this.segmentCodecRef.get();
    }

    @Override
    @NonNull
    public ProtocolVersionRegistry getProtocolVersionRegistry() {
        return this.protocolVersionRegistryRef.get();
    }

    @Override
    @NonNull
    public ConsistencyLevelRegistry getConsistencyLevelRegistry() {
        return this.consistencyLevelRegistryRef.get();
    }

    @Override
    @NonNull
    public WriteTypeRegistry getWriteTypeRegistry() {
        return this.writeTypeRegistryRef.get();
    }

    @Override
    @NonNull
    public NettyOptions getNettyOptions() {
        return this.nettyOptionsRef.get();
    }

    @Override
    @NonNull
    public WriteCoalescer getWriteCoalescer() {
        return this.writeCoalescerRef.get();
    }

    @Override
    @NonNull
    public Optional<SslHandlerFactory> getSslHandlerFactory() {
        return this.sslHandlerFactoryRef.get();
    }

    @Override
    @NonNull
    public ChannelFactory getChannelFactory() {
        return this.channelFactoryRef.get();
    }

    @Override
    @NonNull
    public ChannelPoolFactory getChannelPoolFactory() {
        return this.channelPoolFactory;
    }

    @Override
    @NonNull
    public TopologyMonitor getTopologyMonitor() {
        return this.topologyMonitorRef.get();
    }

    @Override
    @NonNull
    public MetadataManager getMetadataManager() {
        return this.metadataManagerRef.get();
    }

    @Override
    @NonNull
    public LoadBalancingPolicyWrapper getLoadBalancingPolicyWrapper() {
        return this.loadBalancingPolicyWrapperRef.get();
    }

    @Override
    @NonNull
    public ControlConnection getControlConnection() {
        return this.controlConnectionRef.get();
    }

    @Override
    @NonNull
    public RequestProcessorRegistry getRequestProcessorRegistry() {
        return this.requestProcessorRegistryRef.get();
    }

    @Override
    @NonNull
    public SchemaQueriesFactory getSchemaQueriesFactory() {
        return this.schemaQueriesFactoryRef.get();
    }

    @Override
    @NonNull
    public SchemaParserFactory getSchemaParserFactory() {
        return this.schemaParserFactoryRef.get();
    }

    @Override
    @NonNull
    public TokenFactoryRegistry getTokenFactoryRegistry() {
        return this.tokenFactoryRegistryRef.get();
    }

    @Override
    @NonNull
    public ReplicationStrategyFactory getReplicationStrategyFactory() {
        return this.replicationStrategyFactoryRef.get();
    }

    @Override
    @NonNull
    public PoolManager getPoolManager() {
        return this.poolManagerRef.get();
    }

    @Override
    @NonNull
    public MetricsFactory getMetricsFactory() {
        return this.metricsFactoryRef.get();
    }

    @Override
    @NonNull
    public MetricIdGenerator getMetricIdGenerator() {
        return this.metricIdGeneratorRef.get();
    }

    @Override
    @NonNull
    public RequestThrottler getRequestThrottler() {
        return this.requestThrottlerRef.get();
    }

    @Override
    @NonNull
    public NodeStateListener getNodeStateListener() {
        return this.nodeStateListenerRef.get();
    }

    @Override
    @NonNull
    public SchemaChangeListener getSchemaChangeListener() {
        return this.schemaChangeListenerRef.get();
    }

    @Override
    @NonNull
    public RequestTracker getRequestTracker() {
        return this.requestTrackerRef.get();
    }

    @Override
    @Nullable
    public String getLocalDatacenter(@NonNull String profileName) {
        return this.localDatacentersFromBuilder.get(profileName);
    }

    @Override
    @Deprecated
    @Nullable
    public Predicate<Node> getNodeFilter(@NonNull String profileName) {
        return this.nodeFiltersFromBuilder.get(profileName);
    }

    @Override
    @Nullable
    public NodeDistanceEvaluator getNodeDistanceEvaluator(@NonNull String profileName) {
        return this.nodeDistanceEvaluatorsFromBuilder.get(profileName);
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    @NonNull
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    @NonNull
    public ProtocolVersion getProtocolVersion() {
        return this.getChannelFactory().getProtocolVersion();
    }

    @Override
    @NonNull
    public Map<String, String> getStartupOptions() {
        return this.startupOptionsRef.get();
    }

    protected RequestLogFormatter buildRequestLogFormatter() {
        return new RequestLogFormatter(this);
    }

    @Override
    @NonNull
    public RequestLogFormatter getRequestLogFormatter() {
        return this.requestLogFormatterRef.get();
    }

    @Override
    @NonNull
    public List<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListenersRef.get();
    }

    @Override
    @Nullable
    public Object getMetricRegistry() {
        return this.metricRegistry;
    }
}

