/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.LocalRackHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OptionalLocalRackHelper
implements LocalRackHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OptionalLocalRackHelper.class);
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;

    public OptionalLocalRackHelper(@NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        this.profile = profile;
        this.logPrefix = logPrefix;
    }

    @Override
    @NonNull
    public Optional<String> discoverLocalRack(@NonNull Map<UUID, Node> nodes) {
        if (this.profile.isDefined(DefaultDriverOption.LOAD_BALANCING_LOCAL_RACK)) {
            String localRack = this.profile.getString(DefaultDriverOption.LOAD_BALANCING_LOCAL_RACK);
            LOG.debug("[{}] Local rack set from configuration: {}", (Object)this.logPrefix, (Object)localRack);
            return Optional.of(localRack);
        }
        LOG.debug("[{}] Local rack not set, rack awareness will be disabled", (Object)this.logPrefix);
        return Optional.empty();
    }
}

