/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultGeometry;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodec;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCLineString;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LineStringCodec
extends GeometryCodec<LineString> {
    private static final GenericType<LineString> JAVA_TYPE = GenericType.of(LineString.class);

    @Override
    @NonNull
    public GenericType<LineString> getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    @NonNull
    protected LineString fromWellKnownText(@NonNull String source) {
        return new DefaultLineString(DefaultGeometry.fromOgcWellKnownText(source, OGCLineString.class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == LineString.class;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof LineString;
    }

    @Override
    @NonNull
    protected LineString fromWellKnownBinary(@NonNull ByteBuffer bb) {
        return new DefaultLineString(DefaultGeometry.fromOgcWellKnownBinary(bb, OGCLineString.class));
    }

    @Override
    @NonNull
    protected String toWellKnownText(@NonNull LineString geometry) {
        return geometry.asWellKnownText();
    }

    @Override
    @NonNull
    protected ByteBuffer toWellKnownBinary(@NonNull LineString geometry) {
        return geometry.asWellKnownBinary();
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DseDataTypes.LINE_STRING;
    }
}

