/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.ssl;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.ssl.SslHandlerFactory;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JdkSslHandlerFactory
implements SslHandlerFactory {
    private final SslEngineFactory sslEngineFactory;

    public JdkSslHandlerFactory(SslEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
    }

    @Override
    public SslHandler newSslHandler(Channel channel, EndPoint remoteEndpoint) {
        SSLEngine engine = this.sslEngineFactory.newSslEngine(remoteEndpoint);
        return new SslHandler(engine);
    }

    @Override
    public void close() throws Exception {
        this.sslEngineFactory.close();
    }
}

