/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import java.nio.ByteBuffer;
import java.util.List;

public class ValuesHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ByteBuffer[] encodeValues(Object[] values, List<DataType> fieldTypes, CodecRegistry codecRegistry, ProtocolVersion protocolVersion) {
        Preconditions.checkArgument((values.length <= fieldTypes.size() ? 1 : 0) != 0, (String)"Too many values (expected %s, got %s)", (int)fieldTypes.size(), (int)values.length);
        ByteBuffer[] encodedValues = new ByteBuffer[fieldTypes.size()];
        for (int i = 0; i < values.length; ++i) {
            ByteBuffer encodedValue;
            Object value = values[i];
            if (value instanceof Token) {
                if (value instanceof Murmur3Token) {
                    encodedValue = TypeCodecs.BIGINT.encode(((Murmur3Token)value).getValue(), protocolVersion);
                } else if (value instanceof ByteOrderedToken) {
                    encodedValue = TypeCodecs.BLOB.encode(((ByteOrderedToken)value).getValue(), protocolVersion);
                } else {
                    if (!(value instanceof RandomToken)) throw new IllegalArgumentException("Unsupported token type " + value.getClass());
                    encodedValue = TypeCodecs.VARINT.encode(((RandomToken)value).getValue(), protocolVersion);
                }
            } else {
                TypeCodec<Object> codec = value == null ? codecRegistry.codecFor(fieldTypes.get(i)) : codecRegistry.codecFor(fieldTypes.get(i), value);
                encodedValue = codec.encode((DataType)value, protocolVersion);
            }
            encodedValues[i] = encodedValue;
        }
        return encodedValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ByteBuffer[] encodePreparedValues(Object[] values, ColumnDefinitions variableDefinitions, CodecRegistry codecRegistry, ProtocolVersion protocolVersion) {
        int i;
        Preconditions.checkArgument((values.length <= variableDefinitions.size() ? 1 : 0) != 0, (String)"Too many variables (expected %s, got %s)", (int)variableDefinitions.size(), (int)values.length);
        ByteBuffer[] encodedValues = new ByteBuffer[variableDefinitions.size()];
        for (i = 0; i < values.length; ++i) {
            ByteBuffer encodedValue;
            Object value = values[i];
            if (value instanceof Token) {
                if (value instanceof Murmur3Token) {
                    encodedValue = TypeCodecs.BIGINT.encode(((Murmur3Token)value).getValue(), protocolVersion);
                } else if (value instanceof ByteOrderedToken) {
                    encodedValue = TypeCodecs.BLOB.encode(((ByteOrderedToken)value).getValue(), protocolVersion);
                } else {
                    if (!(value instanceof RandomToken)) throw new IllegalArgumentException("Unsupported token type " + value.getClass());
                    encodedValue = TypeCodecs.VARINT.encode(((RandomToken)value).getValue(), protocolVersion);
                }
            } else {
                TypeCodec<Object> codec = value == null ? codecRegistry.codecFor(variableDefinitions.get(i).getType()) : codecRegistry.codecFor(variableDefinitions.get(i).getType(), value);
                encodedValue = codec.encode((DataType)value, protocolVersion);
            }
            encodedValues[i] = encodedValue;
        }
        while (i < encodedValues.length) {
            encodedValues[i] = ProtocolConstants.UNSET_VALUE;
            ++i;
        }
        return encodedValues;
    }
}

