/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.internal.core.protocol.LwtInfo;
import com.datastax.oss.driver.internal.core.protocol.MetadataIdInfo;
import com.datastax.oss.driver.internal.core.protocol.ShardingInfo;
import com.datastax.oss.driver.internal.core.protocol.TabletInfo;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.util.AttributeKey;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;

public class ProtocolFeatureStore {
    private static final AttributeKey<ProtocolFeatureStore> CHANNEL_KEY = AttributeKey.valueOf("protocol_feature_store");
    private final LwtInfo lwtInfo;
    private final ShardingInfo.ConnectionShardingInfo shardingInfo;
    private final TabletInfo tabletInfo;
    private final boolean metadataIdEnabled;
    private ProtocolFeatures protocolFeatures;
    public static final ProtocolFeatureStore EMPTY = new ProtocolFeatureStore(null, null, null, false);

    ProtocolFeatureStore(LwtInfo lwtInfo, ShardingInfo.ConnectionShardingInfo shardingInfo, TabletInfo tabletInfo, boolean metadataIdEnabled) {
        this.lwtInfo = lwtInfo;
        this.shardingInfo = shardingInfo;
        this.tabletInfo = tabletInfo;
        this.metadataIdEnabled = metadataIdEnabled;
    }

    public LwtInfo getLwtFeatureInfo() {
        return this.lwtInfo;
    }

    public ShardingInfo.ConnectionShardingInfo getShardingInfo() {
        return this.shardingInfo;
    }

    public TabletInfo getTabletFeatureInfo() {
        return this.tabletInfo;
    }

    public boolean isMetadataIdEnabled() {
        return this.metadataIdEnabled;
    }

    public static ProtocolFeatureStore parseSupportedOptions(@NonNull Map<String, List<String>> options) {
        LwtInfo lwtInfo = LwtInfo.loadFromSupportedOptions(options);
        ShardingInfo.ConnectionShardingInfo shardingInfo = ShardingInfo.parseShardingInfo(options);
        TabletInfo tabletInfo = TabletInfo.loadFromSupportedOptions(options);
        boolean metadataIdEnabled = MetadataIdInfo.loadFromSupportedOptions(options);
        return new ProtocolFeatureStore(lwtInfo, shardingInfo, tabletInfo, metadataIdEnabled);
    }

    public void populateStartupOptions(@NonNull Map<String, String> options) {
        if (this.lwtInfo != null) {
            this.lwtInfo.populateStartupOptions(options);
        }
        if (this.tabletInfo != null && this.tabletInfo.isEnabled()) {
            TabletInfo.populateStartupOptions(options);
        }
        if (this.metadataIdEnabled) {
            MetadataIdInfo.populateStartupOptions(options);
        }
    }

    public static ProtocolFeatureStore loadFromChannel(@NonNull Channel channel) {
        return channel.attr(CHANNEL_KEY).get();
    }

    public void storeInChannel(@NonNull Channel channel) {
        channel.attr(CHANNEL_KEY).set(this);
    }

    public ProtocolFeatures getProtocolFeatures() {
        if (this.protocolFeatures == null) {
            this.protocolFeatures = this.buildProtocolFeatures();
        }
        return this.protocolFeatures;
    }

    private ProtocolFeatures buildProtocolFeatures() {
        if (this.metadataIdEnabled) {
            return new ProtocolFeatures.Builder().setScyllaUseMetadataId().build();
        }
        return ProtocolFeatures.EMPTY;
    }
}

