/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CQL4SkipMetadataResolveMethod;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.type.ContainerType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.DefaultBoundStatement;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultPreparedStatement
implements PreparedStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPreparedStatement.class);
    private static final Splitter SPACE_SPLITTER = Splitter.onPattern((String)"\\s+");
    private static final Splitter COMMA_SPLITTER = Splitter.onPattern((String)",");
    private final ByteBuffer id;
    private final RepreparePayload repreparePayload;
    private final ColumnDefinitions variableDefinitions;
    private final List<Integer> partitionKeyIndices;
    private volatile ResultMetadata resultMetadata;
    private final CodecRegistry codecRegistry;
    private final ProtocolVersion protocolVersion;
    private final String executionProfileNameForBoundStatements;
    private final DriverExecutionProfile executionProfileForBoundStatements;
    private final ByteBuffer pagingStateForBoundStatements;
    private final CqlIdentifier routingKeyspaceForBoundStatements;
    private final ByteBuffer routingKeyForBoundStatements;
    private final Token routingTokenForBoundStatements;
    private final Map<String, ByteBuffer> customPayloadForBoundStatements;
    private final Boolean areBoundStatementsIdempotent;
    private final boolean areBoundStatementsTracing;
    private final int pageSizeForBoundStatements;
    private final ConsistencyLevel consistencyLevelForBoundStatements;
    private final ConsistencyLevel serialConsistencyLevelForBoundStatements;
    private final Duration timeoutForBoundStatements;
    private final Partitioner partitioner;
    private final boolean isLWT;
    private volatile boolean skipMetadata;

    public DefaultPreparedStatement(ByteBuffer id, String query, ColumnDefinitions variableDefinitions, List<Integer> partitionKeyIndices, ByteBuffer resultMetadataId, ColumnDefinitions resultSetDefinitions, CqlIdentifier keyspace, Partitioner partitioner, Map<String, ByteBuffer> customPayloadForPrepare, String executionProfileNameForBoundStatements, DriverExecutionProfile executionProfileForBoundStatements, CqlIdentifier routingKeyspaceForBoundStatements, ByteBuffer routingKeyForBoundStatements, Token routingTokenForBoundStatements, Map<String, ByteBuffer> customPayloadForBoundStatements, Boolean areBoundStatementsIdempotent, Duration timeoutForBoundStatements, ByteBuffer pagingStateForBoundStatements, int pageSizeForBoundStatements, ConsistencyLevel consistencyLevelForBoundStatements, ConsistencyLevel serialConsistencyLevelForBoundStatements, boolean areBoundStatementsTracing, CodecRegistry codecRegistry, ProtocolVersion protocolVersion, boolean isLWT) {
        this.id = id;
        this.partitionKeyIndices = partitionKeyIndices;
        this.repreparePayload = new RepreparePayload(id, query, keyspace, customPayloadForPrepare);
        this.variableDefinitions = variableDefinitions;
        this.resultMetadata = new ResultMetadata(resultMetadataId, resultSetDefinitions);
        this.executionProfileNameForBoundStatements = executionProfileNameForBoundStatements;
        this.executionProfileForBoundStatements = executionProfileForBoundStatements;
        this.routingKeyspaceForBoundStatements = routingKeyspaceForBoundStatements;
        this.routingKeyForBoundStatements = routingKeyForBoundStatements;
        this.routingTokenForBoundStatements = routingTokenForBoundStatements;
        this.customPayloadForBoundStatements = customPayloadForBoundStatements;
        this.areBoundStatementsIdempotent = areBoundStatementsIdempotent;
        this.timeoutForBoundStatements = timeoutForBoundStatements;
        this.pagingStateForBoundStatements = pagingStateForBoundStatements;
        this.pageSizeForBoundStatements = pageSizeForBoundStatements;
        this.consistencyLevelForBoundStatements = consistencyLevelForBoundStatements;
        this.serialConsistencyLevelForBoundStatements = serialConsistencyLevelForBoundStatements;
        this.areBoundStatementsTracing = areBoundStatementsTracing;
        this.partitioner = partitioner;
        this.codecRegistry = codecRegistry;
        this.protocolVersion = protocolVersion;
        this.isLWT = isLWT;
        this.skipMetadata = DefaultPreparedStatement.resolveSkipMetadata(query, resultMetadataId, resultSetDefinitions, this.executionProfileForBoundStatements);
    }

    @Override
    @NonNull
    public ByteBuffer getId() {
        return this.id;
    }

    @Override
    @NonNull
    public String getQuery() {
        return this.repreparePayload.query;
    }

    @Override
    @NonNull
    public ColumnDefinitions getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public boolean isSkipMetadata() {
        return this.skipMetadata;
    }

    @Override
    @NonNull
    public List<Integer> getPartitionKeyIndices() {
        return this.partitionKeyIndices;
    }

    @Override
    public ByteBuffer getResultMetadataId() {
        return this.resultMetadata.resultMetadataId;
    }

    @Override
    @NonNull
    public ColumnDefinitions getResultSetDefinitions() {
        return this.resultMetadata.resultSetDefinitions;
    }

    @Override
    public boolean isLWT() {
        return this.isLWT;
    }

    @Override
    public void setResultMetadata(@NonNull ByteBuffer newResultMetadataId, @NonNull ColumnDefinitions newResultSetDefinitions) {
        this.skipMetadata = DefaultPreparedStatement.resolveSkipMetadata(this.getQuery(), newResultMetadataId, newResultSetDefinitions, this.executionProfileForBoundStatements);
        this.resultMetadata = new ResultMetadata(newResultMetadataId, newResultSetDefinitions);
    }

    @Override
    @NonNull
    public BoundStatement bind(Object ... values) {
        return new DefaultBoundStatement(this, this.variableDefinitions, ValuesHelper.encodePreparedValues(values, this.variableDefinitions, this.codecRegistry, this.protocolVersion), this.executionProfileNameForBoundStatements, this.executionProfileForBoundStatements, this.routingKeyspaceForBoundStatements, this.routingKeyForBoundStatements, this.routingTokenForBoundStatements, this.customPayloadForBoundStatements, this.areBoundStatementsIdempotent, this.areBoundStatementsTracing, Long.MIN_VALUE, this.pagingStateForBoundStatements, this.pageSizeForBoundStatements, this.consistencyLevelForBoundStatements, this.serialConsistencyLevelForBoundStatements, this.timeoutForBoundStatements, this.codecRegistry, this.protocolVersion, null, Integer.MIN_VALUE);
    }

    @Override
    @NonNull
    public BoundStatementBuilder boundStatementBuilder(Object ... values) {
        return new BoundStatementBuilder(this, this.variableDefinitions, ValuesHelper.encodePreparedValues(values, this.variableDefinitions, this.codecRegistry, this.protocolVersion), this.executionProfileNameForBoundStatements, this.executionProfileForBoundStatements, this.routingKeyspaceForBoundStatements, this.routingKeyForBoundStatements, this.routingTokenForBoundStatements, this.customPayloadForBoundStatements, this.areBoundStatementsIdempotent, this.areBoundStatementsTracing, Long.MIN_VALUE, this.pagingStateForBoundStatements, this.pageSizeForBoundStatements, this.consistencyLevelForBoundStatements, this.serialConsistencyLevelForBoundStatements, this.timeoutForBoundStatements, this.codecRegistry, this.protocolVersion);
    }

    public RepreparePayload getRepreparePayload() {
        return this.repreparePayload;
    }

    private static boolean resolveSkipMetadata(String query, ByteBuffer resultMetadataId, ColumnDefinitions resultSet, DriverExecutionProfile executionProfileForBoundStatements) {
        if (resultSet == null || resultSet.size() == 0) {
            return false;
        }
        if (resultMetadataId != null && resultMetadataId.capacity() > 0) {
            return true;
        }
        CQL4SkipMetadataResolveMethod resolveMethod = CQL4SkipMetadataResolveMethod.SMART;
        if (executionProfileForBoundStatements != null) {
            String resolveMethodName = executionProfileForBoundStatements.getString(DefaultDriverOption.PREPARE_SKIP_CQL4_METADATA_RESOLVE_METHOD);
            try {
                resolveMethod = CQL4SkipMetadataResolveMethod.fromValue(resolveMethodName);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Property advanced.prepared-statements.skip-cql4-metadata-resolve-method is incorrectly set to `{}`, available options: smart, enabled, disabled. Defaulting to `SMART`", (Object)resolveMethodName);
                resolveMethod = CQL4SkipMetadataResolveMethod.SMART;
            }
        }
        switch (resolveMethod) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        if (DefaultPreparedStatement.isWildcardSelect(query)) {
            LOGGER.warn("Prepared statement {} is a wildcard select, which can cause prepared statement invalidation issues when executed on CQL4. These issues may lead to broken deserialization or data corruption. To mitigate this, the driver ensures that the server returns metadata with each query for such statements, though this negatively impacts performance. To avoid this, consider using a targeted select instead. Find more mitigation options in description of `advanced.prepared-statements.skip-cql4-metadata-resolve-method` flag", (Object)query);
            return false;
        }
        for (ColumnDefinition columnDefinition : resultSet) {
            if (!DefaultPreparedStatement.containsUDT(columnDefinition.getType())) continue;
            LOGGER.warn("Prepared statement {} contains UDT in result, which can cause prepared statement invalidation issues when executed on CQL4. These issues may lead to broken deserialization or data corruption. To mitigate this, the driver ensures that the server returns metadata with each query for such statements, though this negatively impacts performance. To avoid this, consider using regular columns instead of UDT. Find more mitigation options in description of `advanced.prepared-statements.skip-cql4-metadata-resolve-method` flag", (Object)query);
            return false;
        }
        return true;
    }

    private static boolean containsUDT(DataType dataType) {
        if (dataType instanceof ContainerType) {
            return DefaultPreparedStatement.containsUDT(((ContainerType)((Object)dataType)).getElementType());
        }
        if (dataType instanceof TupleType) {
            for (DataType elementType : ((TupleType)dataType).getComponentTypes()) {
                if (!DefaultPreparedStatement.containsUDT(elementType)) continue;
                return true;
            }
            return false;
        }
        if (dataType instanceof MapType) {
            return DefaultPreparedStatement.containsUDT(((MapType)dataType).getKeyType()) || DefaultPreparedStatement.containsUDT(((MapType)dataType).getValueType());
        }
        return dataType instanceof UserDefinedType;
    }

    private static boolean isWildcardSelect(String query) {
        List chunks = SPACE_SPLITTER.splitToList((CharSequence)query.trim().toLowerCase());
        if (chunks.size() < 2) {
            return false;
        }
        if (!((String)chunks.get(0)).equals("select")) {
            return false;
        }
        for (String chunk : chunks) {
            if (chunk.equals("from")) {
                return false;
            }
            if (chunk.equals("*")) {
                return true;
            }
            for (String part : COMMA_SPLITTER.split((CharSequence)chunk)) {
                if (!part.equals("*")) continue;
                return true;
            }
        }
        return false;
    }

    private static class ResultMetadata {
        private ByteBuffer resultMetadataId;
        private ColumnDefinitions resultSetDefinitions;

        private ResultMetadata(ByteBuffer resultMetadataId, ColumnDefinitions resultSetDefinitions) {
            this.resultMetadataId = resultMetadataId;
            this.resultSetDefinitions = resultSetDefinitions;
        }
    }
}

