/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.MandatoryLocalDcHelper;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.SimpleQueryPlan;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.MapMaker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultLoadBalancingPolicy
extends BasicLoadBalancingPolicy
implements RequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLoadBalancingPolicy.class);
    private static final long NEWLY_UP_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final int MAX_IN_FLIGHT_THRESHOLD = 10;
    private static final long RESPONSE_COUNT_RESET_INTERVAL_NANOS = TimeUnit.MILLISECONDS.toNanos(200L);
    protected final ConcurrentMap<Node, NodeResponseRateSample> responseTimes;
    protected final Map<Node, Long> upTimes = new ConcurrentHashMap<Node, Long>();
    private final boolean avoidSlowReplicas = this.profile.getBoolean(DefaultDriverOption.LOAD_BALANCING_POLICY_SLOW_AVOIDANCE, true);

    public DefaultLoadBalancingPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        super(context, profileName);
        this.responseTimes = new MapMaker().weakKeys().makeMap();
    }

    @Override
    @NonNull
    public Optional<RequestTracker> getRequestTracker() {
        if (this.avoidSlowReplicas) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    protected Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        return new MandatoryLocalDcHelper(this.context, this.profile, this.logPrefix).discoverLocalDc(nodes);
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        if (!this.avoidSlowReplicas) {
            return super.newQueryPlan(request, session);
        }
        Object[] currentNodes = this.getLiveNodes().dc(this.getLocalDatacenter()).toArray();
        Set<Node> allReplicas = this.getReplicas(request, session);
        int replicaCount = 0;
        int localRackReplicaCount = 0;
        String localRack = this.getLocalRack();
        if (!allReplicas.isEmpty()) {
            for (int i = 0; i < currentNodes.length; ++i) {
                Node node = (Node)currentNodes[i];
                if (!allReplicas.contains(node)) continue;
                if (Objects.equals(node.getRack(), localRack) && Objects.equals(node.getDatacenter(), this.getLocalDatacenter())) {
                    ArrayUtils.bubbleUp(currentNodes, i, localRackReplicaCount);
                    ++localRackReplicaCount;
                } else {
                    ArrayUtils.bubbleUp(currentNodes, i, replicaCount);
                }
                ++replicaCount;
            }
            if (replicaCount > 1) {
                if (localRack != null && localRackReplicaCount > 0) {
                    this.shuffleHead(currentNodes, localRackReplicaCount);
                    this.shuffleInRange(currentNodes, localRackReplicaCount, replicaCount - 1);
                } else {
                    this.shuffleHead(currentNodes, replicaCount);
                }
                if (replicaCount > 2) {
                    int unhealthyReplicasCount;
                    assert (session != null);
                    Node newestUpReplica = null;
                    BitSet unhealthyReplicas = null;
                    long mostRecentUpTimeNanos = -1L;
                    long now = this.nanoTime();
                    for (int i = 0; i < replicaCount; ++i) {
                        Node node = (Node)currentNodes[i];
                        assert (node != null);
                        Long upTimeNanos = this.upTimes.get(node);
                        if (upTimeNanos != null && now - upTimeNanos - NEWLY_UP_INTERVAL_NANOS < 0L && upTimeNanos - mostRecentUpTimeNanos > 0L) {
                            newestUpReplica = node;
                            mostRecentUpTimeNanos = upTimeNanos;
                        }
                        if (newestUpReplica != null || !this.isUnhealthy(node, session, now)) continue;
                        if (unhealthyReplicas == null) {
                            unhealthyReplicas = new BitSet(replicaCount);
                        }
                        unhealthyReplicas.set(i);
                    }
                    int n = unhealthyReplicasCount = unhealthyReplicas == null ? 0 : unhealthyReplicas.cardinality();
                    if (newestUpReplica == null && unhealthyReplicasCount > 0 && (double)unhealthyReplicasCount < (double)replicaCount / 2.0) {
                        int counter = 0;
                        for (int i = replicaCount - 1; i >= 0 && counter < unhealthyReplicasCount; --i) {
                            if (!unhealthyReplicas.get(i)) continue;
                            ArrayUtils.bubbleDown(currentNodes, i, replicaCount - 1 - counter);
                            ++counter;
                        }
                    } else if ((newestUpReplica == currentNodes[0] || newestUpReplica == currentNodes[1]) && this.diceRoll1d4() != 1) {
                        ArrayUtils.bubbleDown(currentNodes, newestUpReplica == currentNodes[0] ? 0 : 1, replicaCount - 1);
                    }
                    if (this.getInFlight((Node)currentNodes[0], session) > this.getInFlight((Node)currentNodes[1], session)) {
                        ArrayUtils.swap(currentNodes, 0, 1);
                    }
                }
            }
        }
        LOG.trace("[{}] Prioritizing {} local replicas", (Object)this.logPrefix, (Object)replicaCount);
        ArrayUtils.rotate(currentNodes, replicaCount, currentNodes.length - replicaCount, this.roundRobinAmount.getAndUpdate(INCREMENT));
        QueryPlan plan = currentNodes.length == 0 ? QueryPlan.EMPTY : new SimpleQueryPlan(currentNodes);
        return this.maybeAddDcFailover(request, plan);
    }

    @Override
    public void onNodeSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        this.updateResponseTimes(node);
    }

    @Override
    public void onNodeError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        this.updateResponseTimes(node);
    }

    protected long nanoTime() {
        return System.nanoTime();
    }

    protected int diceRoll1d4() {
        return ThreadLocalRandom.current().nextInt(4);
    }

    protected boolean isUnhealthy(@NonNull Node node, @NonNull Session session, long now) {
        return this.isBusy(node, session) && this.isResponseRateInsufficient(node, now);
    }

    protected boolean isBusy(@NonNull Node node, @NonNull Session session) {
        return this.getInFlight(node, session) >= 10;
    }

    protected boolean isResponseRateInsufficient(@NonNull Node node, long now) {
        NodeResponseRateSample sample = (NodeResponseRateSample)this.responseTimes.get(node);
        return sample != null && !sample.hasSufficientResponses(now);
    }

    protected void updateResponseTimes(@NonNull Node node) {
        this.responseTimes.compute(node, (k, v) -> v == null ? new NodeResponseRateSample() : ((NodeResponseRateSample)v).next());
    }

    protected int getInFlight(@NonNull Node node, @NonNull Session session) {
        ChannelPool pool = ((DefaultSession)session).getPools().get(node);
        return pool == null ? 0 : pool.getInFlight();
    }

    protected class NodeResponseRateSample {
        @VisibleForTesting
        protected final long oldest;
        @VisibleForTesting
        protected final OptionalLong newest;

        private NodeResponseRateSample() {
            long now;
            this.oldest = now = DefaultLoadBalancingPolicy.this.nanoTime();
            this.newest = OptionalLong.empty();
        }

        private NodeResponseRateSample(long oldestSample) {
            this(oldestSample, this$0.nanoTime());
        }

        private NodeResponseRateSample(long oldestSample, long newestSample) {
            this.oldest = oldestSample;
            this.newest = OptionalLong.of(newestSample);
        }

        @VisibleForTesting
        protected NodeResponseRateSample(AtomicLongArray times) {
            assert (times.length() >= 1);
            this.oldest = times.get(0);
            this.newest = times.length() > 1 ? OptionalLong.of(times.get(1)) : OptionalLong.empty();
        }

        private NodeResponseRateSample next() {
            return new NodeResponseRateSample(this.getNewestValidSample(), DefaultLoadBalancingPolicy.this.nanoTime());
        }

        private long getNewestValidSample() {
            return this.newest.orElse(this.oldest);
        }

        private boolean hasSufficientResponses(long now) {
            if (!this.newest.isPresent()) {
                return true;
            }
            long threshold = now - RESPONSE_COUNT_RESET_INTERVAL_NANOS;
            return this.oldest - threshold >= 0L;
        }
    }
}

