/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistanceEvaluator;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.Tablet;
import com.datastax.oss.driver.api.core.metadata.TabletMap;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.DefaultNodeDistanceEvaluatorHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalDcHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalRackHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.DcAgnosticNodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.MultiDcNodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.NodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.SingleDcNodeSet;
import com.datastax.oss.driver.internal.core.metadata.token.TokenLong64;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.collection.CompositeQueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.LazyQueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.SimpleQueryPlan;
import com.datastax.oss.driver.shaded.guava.common.base.Predicate;
import com.datastax.oss.driver.shaded.guava.common.base.Predicates;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BasicLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLoadBalancingPolicy.class);
    protected static final IntUnaryOperator INCREMENT = i -> i == Integer.MAX_VALUE ? 0 : i + 1;
    private static final Object[] EMPTY_NODES = new Object[0];
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;
    protected final AtomicInteger roundRobinAmount = new AtomicInteger();
    private final int maxNodesPerRemoteDc;
    private final boolean allowDcFailoverForLocalCl;
    private final ConsistencyLevel defaultConsistencyLevel;
    private volatile LoadBalancingPolicy.DistanceReporter distanceReporter;
    private volatile NodeDistanceEvaluator nodeDistanceEvaluator;
    private volatile String localDc;
    private volatile String localRack;
    private volatile NodeSet liveNodes;
    private final LinkedHashSet<String> preferredRemoteDcs;

    public BasicLoadBalancingPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        this.context = (InternalDriverContext)context;
        this.profile = context.getConfig().getProfile(profileName);
        this.logPrefix = context.getSessionName() + "|" + profileName;
        this.maxNodesPerRemoteDc = this.profile.getInt(DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC);
        this.allowDcFailoverForLocalCl = this.profile.getBoolean(DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS);
        this.defaultConsistencyLevel = this.context.getConsistencyLevelRegistry().nameToLevel(this.profile.getString(DefaultDriverOption.REQUEST_CONSISTENCY));
        this.preferredRemoteDcs = new LinkedHashSet<String>(this.profile.getStringList(DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_PREFERRED_REMOTE_DCS));
    }

    @Nullable
    protected String getLocalDatacenter() {
        return this.localDc;
    }

    @Nullable
    protected String getLocalRack() {
        return this.localRack;
    }

    protected NodeSet getLiveNodes() {
        return this.liveNodes;
    }

    @Override
    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.distanceReporter = distanceReporter;
        this.localDc = this.discoverLocalDc(nodes).orElse(null);
        this.localRack = this.localDc != null ? (String)this.discoverLocalRack(nodes).orElse(null) : null;
        this.nodeDistanceEvaluator = this.createNodeDistanceEvaluator(this.localDc, nodes);
        this.liveNodes = this.localDc == null ? new DcAgnosticNodeSet() : (this.maxNodesPerRemoteDc <= 0 ? new SingleDcNodeSet(this.localDc) : new MultiDcNodeSet());
        for (Node node : nodes.values()) {
            NodeDistance distance = this.computeNodeDistance(node);
            distanceReporter.setDistance(node, distance);
            if (distance == NodeDistance.IGNORED || node.getState() == NodeState.DOWN) continue;
            this.liveNodes.add(node);
        }
    }

    @NonNull
    protected Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        return new OptionalLocalDcHelper(this.context, this.profile, this.logPrefix).discoverLocalDc(nodes);
    }

    @NonNull
    protected Optional<String> discoverLocalRack(@NonNull Map<UUID, Node> nodes) {
        return new OptionalLocalRackHelper(this.profile, this.logPrefix).discoverLocalRack(nodes);
    }

    @NonNull
    protected NodeDistanceEvaluator createNodeDistanceEvaluator(@Nullable String localDc, @NonNull Map<UUID, Node> nodes) {
        return new DefaultNodeDistanceEvaluatorHelper(this.context, this.profile, this.logPrefix).createNodeDistanceEvaluator(localDc, nodes);
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        Object[] currentNodes = this.liveNodes.dc(this.localDc).toArray();
        Set<Node> allReplicas = this.getReplicas(request, session);
        int replicaCount = 0;
        if (!allReplicas.isEmpty()) {
            for (int i = 0; i < currentNodes.length; ++i) {
                Node node = (Node)currentNodes[i];
                if (!allReplicas.contains(node)) continue;
                ArrayUtils.bubbleUp(currentNodes, i, replicaCount);
                ++replicaCount;
            }
            if (replicaCount > 1) {
                this.shuffleHead(currentNodes, replicaCount);
            }
        }
        LOG.trace("[{}] Prioritizing {} local replicas", (Object)this.logPrefix, (Object)replicaCount);
        ArrayUtils.rotate(currentNodes, replicaCount, currentNodes.length - replicaCount, this.roundRobinAmount.getAndUpdate(INCREMENT));
        QueryPlan plan = currentNodes.length == 0 ? QueryPlan.EMPTY : new SimpleQueryPlan(currentNodes);
        return this.maybeAddDcFailover(request, plan);
    }

    @NonNull
    protected Set<Node> getReplicas(@Nullable Request request, @Nullable Session session) {
        Optional<KeyspaceMetadata> ksMetadata;
        Partitioner partitioner;
        ByteBuffer key;
        Token token;
        CqlIdentifier table;
        CqlIdentifier keyspace;
        if (request == null || session == null) {
            return Collections.emptySet();
        }
        Optional<TokenMap> maybeTokenMap = this.context.getMetadataManager().getMetadata().getTokenMap();
        TabletMap tabletMap = this.context.getMetadataManager().getMetadata().getTabletMap();
        try {
            keyspace = request.getKeyspace();
            if (keyspace == null) {
                keyspace = request.getRoutingKeyspace();
            }
            if (keyspace == null && session.getKeyspace().isPresent()) {
                keyspace = session.getKeyspace().get();
            }
            if (keyspace == null) {
                return Collections.emptySet();
            }
            table = request.getRoutingTable();
            token = request.getRoutingToken();
            ByteBuffer byteBuffer = key = token == null ? request.getRoutingKey() : null;
            if (token == null && key == null) {
                return Collections.emptySet();
            }
            partitioner = request.getPartitioner();
        }
        catch (Exception e) {
            LOG.error("Unexpected error while trying to compute query plan", (Throwable)e);
            return Collections.emptySet();
        }
        if (token == null && partitioner != null) {
            token = partitioner.hash(key);
        }
        if ((ksMetadata = this.context.getMetadataManager().getMetadata().getKeyspace(keyspace)).isPresent() && ksMetadata.get().isUsingTablets()) {
            Tablet targetTablet;
            if (table == null) {
                return Collections.emptySet();
            }
            if (token instanceof TokenLong64 && (targetTablet = tabletMap.getTablet(keyspace, table, ((TokenLong64)token).getValue())) != null) {
                return targetTablet.getReplicaNodes();
            }
            return Collections.emptySet();
        }
        if (!maybeTokenMap.isPresent()) {
            return Collections.emptySet();
        }
        TokenMap tokenMap = maybeTokenMap.get();
        return token != null ? tokenMap.getReplicas(keyspace, token) : tokenMap.getReplicas(keyspace, partitioner, key);
    }

    @NonNull
    protected Queue<Node> maybeAddDcFailover(@Nullable Request request, @NonNull Queue<Node> local) {
        if (this.maxNodesPerRemoteDc <= 0 || this.localDc == null) {
            return local;
        }
        if (!this.allowDcFailoverForLocalCl && request instanceof Statement) {
            Statement statement = (Statement)request;
            ConsistencyLevel consistency = statement.getConsistencyLevel();
            if (consistency == null) {
                consistency = this.defaultConsistencyLevel;
            }
            if (consistency.isDcLocal()) {
                return local;
            }
        }
        if (this.preferredRemoteDcs.isEmpty()) {
            return new CompositeQueryPlan(local, this.buildRemoteQueryPlanAll());
        }
        return new CompositeQueryPlan(local, this.buildRemoteQueryPlanPreferred());
    }

    private QueryPlan buildRemoteQueryPlanAll() {
        return new LazyQueryPlan(){

            @Override
            protected Object[] computeNodes() {
                Object[] remoteNodes = BasicLoadBalancingPolicy.this.liveNodes.dcs().stream().filter(Predicates.not((Predicate)Predicates.equalTo((Object)BasicLoadBalancingPolicy.this.localDc))).flatMap(dc -> BasicLoadBalancingPolicy.this.liveNodes.dc((String)dc).stream().limit(BasicLoadBalancingPolicy.this.maxNodesPerRemoteDc)).toArray();
                if (remoteNodes.length == 0) {
                    return EMPTY_NODES;
                }
                BasicLoadBalancingPolicy.this.shuffleHead(remoteNodes, remoteNodes.length);
                return remoteNodes;
            }
        };
    }

    private QueryPlan buildRemoteQueryPlanPreferred() {
        Set<String> dcs = this.liveNodes.dcs();
        ArrayList orderedDcs = Lists.newArrayListWithCapacity((int)dcs.size());
        orderedDcs.addAll(this.preferredRemoteDcs);
        orderedDcs.addAll(Sets.difference(dcs, this.preferredRemoteDcs));
        QueryPlan[] queryPlans = (QueryPlan[])orderedDcs.stream().filter(Predicates.not((Predicate)Predicates.equalTo((Object)this.localDc))).map(dc -> new LazyQueryPlan((String)dc){
            final /* synthetic */ String val$dc;
            {
                this.val$dc = string;
            }

            @Override
            protected Object[] computeNodes() {
                Object[] rv = BasicLoadBalancingPolicy.this.liveNodes.dc(this.val$dc).stream().limit(BasicLoadBalancingPolicy.this.maxNodesPerRemoteDc).toArray();
                if (rv.length == 0) {
                    return EMPTY_NODES;
                }
                BasicLoadBalancingPolicy.this.shuffleHead(rv, rv.length);
                return rv;
            }
        }).toArray(QueryPlan[]::new);
        return new CompositeQueryPlan(queryPlans);
    }

    protected void shuffleHead(Object[] currentNodes, int headLength) {
        ArrayUtils.shuffleHead(currentNodes, headLength);
    }

    protected void shuffleInRange(Object[] currentNodes, int startIndex, int endIndex) {
        ArrayUtils.shuffleInRange(currentNodes, startIndex, endIndex);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        NodeDistance distance = this.computeNodeDistance(node);
        this.distanceReporter.setDistance(node, distance);
        LOG.debug("[{}] {} was added, setting distance to {}", new Object[]{this.logPrefix, node, distance});
    }

    @Override
    public void onUp(@NonNull Node node) {
        NodeDistance distance = this.computeNodeDistance(node);
        if (node.getDistance() != distance) {
            this.distanceReporter.setDistance(node, distance);
        }
        if (distance != NodeDistance.IGNORED && this.liveNodes.add(node)) {
            LOG.debug("[{}] {} came back UP, added to live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onDown(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} went DOWN, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onRemove(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} was removed, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    protected NodeDistance computeNodeDistance(@NonNull Node node) {
        NodeDistance distance = this.nodeDistanceEvaluator.evaluateDistance(node, this.localDc);
        if (distance != null) {
            return distance;
        }
        if (this.localDc == null) {
            return NodeDistance.LOCAL;
        }
        if (Objects.equals(node.getDatacenter(), this.localDc)) {
            return NodeDistance.LOCAL;
        }
        if (this.maxNodesPerRemoteDc > 0) {
            Object[] remoteNodes = this.liveNodes.dc(node.getDatacenter()).toArray();
            for (int i = 0; i < this.maxNodesPerRemoteDc; ++i) {
                if (i == remoteNodes.length) {
                    return NodeDistance.REMOTE;
                }
                if (remoteNodes[i] != node) continue;
                return NodeDistance.REMOTE;
            }
        }
        return NodeDistance.IGNORED;
    }

    @Override
    public void close() {
    }
}

