/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.connection.BusyConnectionException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.InFlightHandler;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.util.ProtocolUtils;
import com.datastax.oss.driver.internal.core.util.concurrent.UncaughtExceptions;
import com.datastax.oss.driver.shaded.netty.channel.Channel;
import com.datastax.oss.driver.shaded.netty.channel.ChannelFuture;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import com.datastax.oss.driver.shaded.netty.util.concurrent.ScheduledFuture;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class ChannelHandlerRequest
implements ResponseCallback {
    final Channel channel;
    final ChannelHandlerContext ctx;
    final InFlightHandler inFlightHandler;
    private final long timeoutMillis;
    private ScheduledFuture<?> timeoutFuture;

    ChannelHandlerRequest(ChannelHandlerContext ctx, long timeoutMillis) {
        this.ctx = ctx;
        this.channel = ctx.channel();
        this.inFlightHandler = ctx.pipeline().get(InFlightHandler.class);
        assert (this.inFlightHandler != null);
        this.timeoutMillis = timeoutMillis;
    }

    abstract String describe();

    abstract Message getRequest();

    abstract void onResponse(Message var1);

    abstract void fail(String var1, Throwable var2);

    void fail(Throwable cause) {
        this.fail(null, cause);
    }

    void send() {
        assert (this.channel.eventLoop().inEventLoop());
        if (!this.inFlightHandler.preAcquireId()) {
            this.fail(new BusyConnectionException(String.format("%s has reached its maximum number of simultaneous requests", this.channel)));
        } else {
            DriverChannel.RequestMessage message = new DriverChannel.RequestMessage(this.getRequest(), false, Frame.NO_PAYLOAD, this);
            ChannelFuture writeFuture = this.channel.writeAndFlush(message);
            writeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)this::writeListener));
        }
    }

    private void writeListener(Future<? super Void> writeFuture) {
        if (writeFuture.isSuccess()) {
            this.timeoutFuture = this.channel.eventLoop().schedule(this::onTimeout, this.timeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            String message = String.format("%s: failed to send request (%s)", this.describe(), writeFuture.cause());
            this.fail(message, writeFuture.cause());
        }
    }

    @Override
    public final void onResponse(Frame responseFrame) {
        this.timeoutFuture.cancel(true);
        this.onResponse(responseFrame.message);
    }

    @Override
    public final void onFailure(Throwable error) {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(true);
        }
        String message = String.format("%s: unexpected failure (%s)", this.describe(), error);
        this.fail(message, error);
    }

    private void onTimeout() {
        this.fail(new DriverTimeoutException(this.describe() + ": timed out after " + this.timeoutMillis + " ms"));
        if (!this.channel.closeFuture().isDone()) {
            this.channel.writeAndFlush(this).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)UncaughtExceptions::log));
        }
    }

    void failOnUnexpected(Message response) {
        if (response instanceof Error) {
            Error error = (Error)response;
            this.fail(new IllegalArgumentException(String.format("%s: server replied with unexpected error code [%s]: %s", this.describe(), ProtocolUtils.errorCodeString(error.code), error.message)));
        } else {
            this.fail(new IllegalArgumentException(String.format("%s: server replied with unexpected response type (opcode=%s)", this.describe(), ProtocolUtils.opcodeString(response.opcode))));
        }
    }
}

