/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistanceEvaluator;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.internal.core.ContactPoints;
import com.datastax.oss.driver.internal.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfig;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfigFactory;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class SessionBuilder<SelfT extends SessionBuilder, SessionT> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionBuilder.class);
    protected final SelfT self = this;
    protected DriverConfigLoader configLoader;
    protected Set<EndPoint> programmaticContactPoints = new HashSet<EndPoint>();
    protected CqlIdentifier keyspace;
    protected Callable<InputStream> cloudConfigInputStream;
    protected ProgrammaticArguments.Builder programmaticArgumentsBuilder = ProgrammaticArguments.builder();
    private boolean programmaticSslFactory = false;
    private boolean programmaticLocalDatacenter = false;

    @NonNull
    public SelfT withConfigLoader(@Nullable DriverConfigLoader configLoader) {
        this.configLoader = configLoader;
        return this.self;
    }

    @Deprecated
    @NonNull
    protected DriverConfigLoader defaultConfigLoader() {
        return new DefaultDriverConfigLoader();
    }

    @NonNull
    protected DriverConfigLoader defaultConfigLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return new DefaultDriverConfigLoader();
        }
        return new DefaultDriverConfigLoader(classLoader);
    }

    @NonNull
    public SelfT addContactPoints(@NonNull Collection<InetSocketAddress> contactPoints) {
        for (InetSocketAddress contactPoint : contactPoints) {
            this.addContactPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactPoint(@NonNull InetSocketAddress contactPoint) {
        this.programmaticContactPoints.add(new DefaultEndPoint(contactPoint));
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoints(@NonNull Collection<EndPoint> contactPoints) {
        for (EndPoint contactPoint : contactPoints) {
            this.addContactEndPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoint(@NonNull EndPoint contactPoint) {
        this.programmaticContactPoints.add(contactPoint);
        return this.self;
    }

    @NonNull
    public SelfT addTypeCodecs(TypeCodec<?> ... typeCodecs) {
        this.programmaticArgumentsBuilder.addTypeCodecs(typeCodecs);
        return this.self;
    }

    @NonNull
    public SelfT withNodeStateListener(@Nullable NodeStateListener nodeStateListener) {
        this.programmaticArgumentsBuilder.withNodeStateListener(nodeStateListener);
        return this.self;
    }

    @NonNull
    public SelfT withSchemaChangeListener(@Nullable SchemaChangeListener schemaChangeListener) {
        this.programmaticArgumentsBuilder.withSchemaChangeListener(schemaChangeListener);
        return this.self;
    }

    @NonNull
    public SelfT withRequestTracker(@Nullable RequestTracker requestTracker) {
        this.programmaticArgumentsBuilder.withRequestTracker(requestTracker);
        return this.self;
    }

    @NonNull
    public SelfT withAuthProvider(@Nullable AuthProvider authProvider) {
        this.programmaticArgumentsBuilder.withAuthProvider(authProvider);
        return this.self;
    }

    @NonNull
    public SelfT withAuthCredentials(@NonNull String username, @NonNull String password) {
        return this.withAuthProvider(new ProgrammaticPlainTextAuthProvider(username, password));
    }

    @NonNull
    public SelfT withAuthCredentials(@NonNull String username, @NonNull String password, @NonNull String authorizationId) {
        return this.withAuthProvider(new ProgrammaticPlainTextAuthProvider(username, password, authorizationId));
    }

    @Deprecated
    @NonNull
    public SelfT withCredentials(@NonNull String username, @NonNull String password) {
        return this.withAuthCredentials(username, password);
    }

    @Deprecated
    @NonNull
    public SelfT withCredentials(@NonNull String username, @NonNull String password, @NonNull String authorizationId) {
        return this.withAuthCredentials(username, password, authorizationId);
    }

    @NonNull
    public SelfT withSslEngineFactory(@Nullable SslEngineFactory sslEngineFactory) {
        this.programmaticSslFactory = true;
        this.programmaticArgumentsBuilder.withSslEngineFactory(sslEngineFactory);
        return this.self;
    }

    @NonNull
    public SelfT withSslContext(@Nullable SSLContext sslContext) {
        return this.withSslEngineFactory(sslContext == null ? null : new ProgrammaticSslEngineFactory(sslContext));
    }

    public SelfT withLocalDatacenter(@NonNull String profileName, @NonNull String localDatacenter) {
        this.programmaticLocalDatacenter = true;
        this.programmaticArgumentsBuilder.withLocalDatacenter(profileName, localDatacenter);
        return this.self;
    }

    public SelfT withLocalDatacenter(@NonNull String localDatacenter) {
        return this.withLocalDatacenter("default", localDatacenter);
    }

    @NonNull
    public SelfT withNodeDistanceEvaluator(@NonNull String profileName, @NonNull NodeDistanceEvaluator nodeDistanceEvaluator) {
        this.programmaticArgumentsBuilder.withNodeDistanceEvaluator(profileName, nodeDistanceEvaluator);
        return this.self;
    }

    @NonNull
    public SelfT withNodeDistanceEvaluator(@NonNull NodeDistanceEvaluator nodeDistanceEvaluator) {
        return this.withNodeDistanceEvaluator("default", nodeDistanceEvaluator);
    }

    @Deprecated
    @NonNull
    public SelfT withNodeFilter(@NonNull String profileName, @NonNull Predicate<Node> nodeFilter) {
        this.programmaticArgumentsBuilder.withNodeFilter(profileName, nodeFilter);
        return this.self;
    }

    @Deprecated
    @NonNull
    public SelfT withNodeFilter(@NonNull Predicate<Node> nodeFilter) {
        return this.withNodeFilter("default", nodeFilter);
    }

    @NonNull
    public SelfT withKeyspace(@Nullable CqlIdentifier keyspace) {
        this.keyspace = keyspace;
        return this.self;
    }

    @NonNull
    public SelfT withKeyspace(@Nullable String keyspaceName) {
        return this.withKeyspace(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public SelfT withClassLoader(@Nullable ClassLoader classLoader) {
        this.programmaticArgumentsBuilder.withClassLoader(classLoader);
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull Path cloudConfigPath) {
        try {
            URL cloudConfigUrl = cloudConfigPath.toAbsolutePath().normalize().toUri().toURL();
            this.cloudConfigInputStream = cloudConfigUrl::openStream;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Incorrect format of cloudConfigPath", e);
        }
        return this.self;
    }

    @NonNull
    public SelfT withCodecRegistry(@Nullable MutableCodecRegistry codecRegistry) {
        this.programmaticArgumentsBuilder.withCodecRegistry(codecRegistry);
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull URL cloudConfigUrl) {
        this.cloudConfigInputStream = cloudConfigUrl::openStream;
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull InputStream cloudConfigInputStream) {
        this.cloudConfigInputStream = () -> cloudConfigInputStream;
        return this.self;
    }

    @NonNull
    public SelfT withCloudProxyAddress(@Nullable InetSocketAddress cloudProxyAddress) {
        this.programmaticArgumentsBuilder.withCloudProxyAddress(cloudProxyAddress);
        return this.self;
    }

    @NonNull
    public SelfT withClientId(@Nullable UUID clientId) {
        this.programmaticArgumentsBuilder.withStartupClientId(clientId);
        return this.self;
    }

    @NonNull
    public SelfT withApplicationName(@Nullable String applicationName) {
        this.programmaticArgumentsBuilder.withStartupApplicationName(applicationName);
        return this.self;
    }

    @NonNull
    public SelfT withApplicationVersion(@Nullable String applicationVersion) {
        this.programmaticArgumentsBuilder.withStartupApplicationVersion(applicationVersion);
        return this.self;
    }

    @NonNull
    public SelfT withMetricRegistry(@Nullable Object metricRegistry) {
        this.programmaticArgumentsBuilder.withMetricRegistry(metricRegistry);
        return this.self;
    }

    @NonNull
    public CompletionStage<SessionT> buildAsync() {
        System.out.println("Using Scylla optimized driver!!!");
        LOG.info("Using Scylla optimized driver!!!");
        CompletionStage<CqlSession> buildStage = this.buildDefaultSessionAsync();
        CompletionStage<Object> wrapStage = buildStage.thenApply(this::wrap);
        CompletableFutures.propagateCancellation(wrapStage, buildStage);
        return wrapStage;
    }

    @NonNull
    public SessionT build() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.buildAsync());
    }

    protected abstract SessionT wrap(@NonNull CqlSession var1);

    @NonNull
    protected final CompletionStage<CqlSession> buildDefaultSessionAsync() {
        try {
            String configUrlString;
            ProgrammaticArguments programmaticArguments = this.programmaticArgumentsBuilder.build();
            DriverConfigLoader configLoader = this.configLoader != null ? this.configLoader : this.defaultConfigLoader(programmaticArguments.getClassLoader());
            DriverExecutionProfile defaultConfig = configLoader.getInitialConfig().getDefaultProfile();
            if (this.cloudConfigInputStream == null && (configUrlString = defaultConfig.getString(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, null)) != null) {
                this.cloudConfigInputStream = () -> this.getURL(configUrlString).openStream();
            }
            List<String> configContactPoints = defaultConfig.getStringList(DefaultDriverOption.CONTACT_POINTS, Collections.emptyList());
            if (this.cloudConfigInputStream != null) {
                if (!this.programmaticContactPoints.isEmpty() || !configContactPoints.isEmpty()) {
                    LOG.info("Both a secure connect bundle and contact points were provided. These are mutually exclusive. The contact points from the secure bundle will have priority.");
                    configContactPoints = Collections.emptyList();
                    this.programmaticContactPoints = new HashSet<EndPoint>();
                }
                if (this.programmaticSslFactory || defaultConfig.isDefined(DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS)) {
                    LOG.info("Both a secure connect bundle and SSL options were provided. They are mutually exclusive. The SSL options from the secure bundle will have priority.");
                }
                CloudConfig cloudConfig = new CloudConfigFactory().createCloudConfig(this.cloudConfigInputStream.call());
                this.addContactEndPoints(cloudConfig.getEndPoints());
                boolean localDataCenterDefined = this.anyProfileHasDatacenterDefined(configLoader.getInitialConfig());
                if (this.programmaticLocalDatacenter || localDataCenterDefined) {
                    LOG.info("Both a secure connect bundle and a local datacenter were provided. They are mutually exclusive. The local datacenter from the secure bundle will have priority.");
                    this.programmaticArgumentsBuilder.clearDatacenters();
                }
                this.withLocalDatacenter(cloudConfig.getLocalDatacenter());
                this.withSslEngineFactory(cloudConfig.getSslEngineFactory());
                this.withCloudProxyAddress(cloudConfig.getProxyAddress());
                programmaticArguments = this.programmaticArgumentsBuilder.build();
            }
            boolean resolveAddresses = defaultConfig.getBoolean(DefaultDriverOption.RESOLVE_CONTACT_POINTS, true);
            Set<EndPoint> contactPoints = ContactPoints.merge(this.programmaticContactPoints, configContactPoints, resolveAddresses);
            if (this.keyspace == null && defaultConfig.isDefined(DefaultDriverOption.SESSION_KEYSPACE)) {
                this.keyspace = CqlIdentifier.fromCql(defaultConfig.getString(DefaultDriverOption.SESSION_KEYSPACE));
            }
            return DefaultSession.init((InternalDriverContext)this.buildContext(configLoader, programmaticArguments), contactPoints, this.keyspace);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture(t);
        }
    }

    private boolean anyProfileHasDatacenterDefined(DriverConfig driverConfig) {
        for (DriverExecutionProfile driverExecutionProfile : driverConfig.getProfiles().values()) {
            if (!driverExecutionProfile.isDefined(DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)) continue;
            return true;
        }
        return false;
    }

    private URL getURL(String configUrl) throws MalformedURLException {
        try {
            return new URL(configUrl);
        }
        catch (MalformedURLException e1) {
            try {
                return Paths.get(configUrl, new String[0]).toAbsolutePath().normalize().toUri().toURL();
            }
            catch (MalformedURLException e2) {
                e2.addSuppressed(e1);
                throw e2;
            }
        }
    }

    protected DriverContext buildContext(DriverConfigLoader configLoader, ProgrammaticArguments programmaticArguments) {
        DriverContext legacyApiContext = this.buildContext(configLoader, programmaticArguments.getTypeCodecs(), programmaticArguments.getNodeStateListener(), programmaticArguments.getSchemaChangeListener(), programmaticArguments.getRequestTracker(), programmaticArguments.getLocalDatacenters(), programmaticArguments.getNodeFilters(), programmaticArguments.getClassLoader());
        if (legacyApiContext != null) {
            return legacyApiContext;
        }
        return new DefaultDriverContext(configLoader, programmaticArguments);
    }

    @Deprecated
    protected DriverContext buildContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader) {
        return null;
    }
}

