/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import com.scwang.smartrefresh.layout.internal.PaintDrawable;

public class ArrowDrawable
extends PaintDrawable {
    private int mWidth = 0;
    private int mHeight = 0;
    private Path mPath = new Path();

    public void draw(@NonNull Canvas canvas) {
        ArrowDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        if (this.mWidth != width || this.mHeight != height) {
            int lineWidth = width * 30 / 225;
            this.mPath.reset();
            float vector1 = (float)((double)lineWidth * Math.sin(0.7853981633974483));
            float vector2 = (float)((double)lineWidth / Math.sin(0.7853981633974483));
            this.mPath.moveTo((float)(width / 2), (float)height);
            this.mPath.lineTo(0.0f, (float)(height / 2));
            this.mPath.lineTo(vector1, (float)(height / 2) - vector1);
            this.mPath.lineTo((float)(width / 2 - lineWidth / 2), (float)height - vector2 - (float)(lineWidth / 2));
            this.mPath.lineTo((float)(width / 2 - lineWidth / 2), 0.0f);
            this.mPath.lineTo((float)(width / 2 + lineWidth / 2), 0.0f);
            this.mPath.lineTo((float)(width / 2 + lineWidth / 2), (float)height - vector2 - (float)(lineWidth / 2));
            this.mPath.lineTo((float)width - vector1, (float)(height / 2) - vector1);
            this.mPath.lineTo((float)width, (float)(height / 2));
            this.mPath.close();
            this.mWidth = width;
            this.mHeight = height;
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

