/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.util.AttributeSet;
import android.view.View;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BallPulseFooter
extends InternalAbstract
implements RefreshFooter {
    public static final int DEFAULT_SIZE = 50;
    protected boolean mManualNormalColor;
    protected boolean mManualAnimationColor;
    protected Paint mPaint;
    protected int mNormalColor = -1118482;
    protected int mAnimatingColor = -1615546;
    protected float mCircleSpacing;
    protected float[] mScaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    protected boolean mIsStarted = false;
    protected ArrayList<ValueAnimator> mAnimators;
    protected Map<ValueAnimator, ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new HashMap<ValueAnimator, ValueAnimator.AnimatorUpdateListener>();

    public BallPulseFooter(@NonNull Context context) {
        this(context, null);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BallPulseFooter(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        BallPulseFooter thisView = this;
        thisView.setMinimumHeight(DensityUtil.dp2px(60.0f));
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BallPulseFooter);
        this.mPaint = new Paint();
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mSpinnerStyle = SpinnerStyle.Translate;
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.BallPulseFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.BallPulseFooter_srlNormalColor)) {
            this.setNormalColor(ta.getColor(R.styleable.BallPulseFooter_srlNormalColor, 0));
        }
        if (ta.hasValue(R.styleable.BallPulseFooter_srlAnimatingColor)) {
            this.setAnimatingColor(ta.getColor(R.styleable.BallPulseFooter_srlAnimatingColor, 0));
        }
        ta.recycle();
        this.mCircleSpacing = DensityUtil.dp2px(4.0f);
        this.mAnimators = new ArrayList();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            animator.setDuration(750L);
            animator.setRepeatCount(-1);
            animator.setTarget((Object)i);
            animator.setStartDelay((long)delays[i]);
            this.mUpdateListeners.put(animator, new ValueAnimator.AnimatorUpdateListener((View)thisView){
                final /* synthetic */ View val$thisView;
                {
                    this.val$thisView = view;
                }

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallPulseFooter.this.mScaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    this.val$thisView.postInvalidate();
                }
            });
            this.mAnimators.add(animator);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimators != null) {
            for (int i = 0; i < this.mAnimators.size(); ++i) {
                this.mAnimators.get(i).cancel();
                this.mAnimators.get(i).removeAllListeners();
                this.mAnimators.get(i).removeAllUpdateListeners();
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        BallPulseFooter thisView = this;
        int width = thisView.getWidth();
        int height = thisView.getHeight();
        float radius = ((float)Math.min(width, height) - this.mCircleSpacing * 2.0f) / 6.0f;
        float x = (float)(width / 2) - (radius * 2.0f + this.mCircleSpacing);
        float y = height / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + this.mCircleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.mScaleFloats[i], this.mScaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
            canvas.restore();
        }
        super.dispatchDraw(canvas);
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        if (this.mIsStarted) {
            return;
        }
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            ValueAnimator animator = this.mAnimators.get(i);
            ValueAnimator.AnimatorUpdateListener updateListener = this.mUpdateListeners.get(animator);
            if (updateListener != null) {
                animator.addUpdateListener(updateListener);
            }
            animator.start();
        }
        this.mIsStarted = true;
        this.mPaint.setColor(this.mAnimatingColor);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mAnimators != null && this.mIsStarted) {
            this.mIsStarted = false;
            this.mScaleFloats = new float[]{1.0f, 1.0f, 1.0f};
            for (ValueAnimator animator : this.mAnimators) {
                if (animator == null) continue;
                animator.removeAllUpdateListeners();
                animator.end();
            }
        }
        this.mPaint.setColor(this.mNormalColor);
        return 0;
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        return false;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (!this.mManualAnimationColor && colors.length > 1) {
            this.setAnimatingColor(colors[0]);
            this.mManualAnimationColor = false;
        }
        if (!this.mManualNormalColor) {
            if (colors.length > 1) {
                this.setNormalColor(colors[1]);
            } else if (colors.length > 0) {
                this.setNormalColor(ColorUtils.compositeColors((int)-1711276033, (int)colors[0]));
            }
            this.mManualNormalColor = false;
        }
    }

    public BallPulseFooter setSpinnerStyle(SpinnerStyle mSpinnerStyle) {
        this.mSpinnerStyle = mSpinnerStyle;
        return this;
    }

    public BallPulseFooter setNormalColor(@ColorInt int color) {
        this.mNormalColor = color;
        this.mManualNormalColor = true;
        if (!this.mIsStarted) {
            this.mPaint.setColor(color);
        }
        return this;
    }

    public BallPulseFooter setAnimatingColor(@ColorInt int color) {
        this.mAnimatingColor = color;
        this.mManualAnimationColor = true;
        if (this.mIsStarted) {
            this.mPaint.setColor(color);
        }
        return this;
    }
}

