/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.OnTwoLevelListener;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;

public class TwoLevelHeader
extends InternalAbstract
implements RefreshHeader {
    protected int mSpinner;
    protected float mPercent = 0.0f;
    protected float mMaxRage = 2.5f;
    protected float mFloorRage = 1.9f;
    protected float mRefreshRage = 1.0f;
    protected boolean mEnableTwoLevel = true;
    protected boolean mEnablePullToCloseTwoLevel = true;
    protected int mFloorDuration = 1000;
    protected int mHeaderHeight;
    protected RefreshHeader mRefreshHeader;
    protected RefreshKernel mRefreshKernel;
    protected OnTwoLevelListener mTwoLevelListener;

    public TwoLevelHeader(@NonNull Context context) {
        this(context, null);
    }

    public TwoLevelHeader(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TwoLevelHeader(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TwoLevelHeader);
        this.mMaxRage = ta.getFloat(R.styleable.TwoLevelHeader_srlMaxRage, this.mMaxRage);
        this.mFloorRage = ta.getFloat(R.styleable.TwoLevelHeader_srlFloorRage, this.mFloorRage);
        this.mRefreshRage = ta.getFloat(R.styleable.TwoLevelHeader_srlRefreshRage, this.mRefreshRage);
        this.mFloorDuration = ta.getInt(R.styleable.TwoLevelHeader_srlFloorDuration, this.mFloorDuration);
        this.mEnableTwoLevel = ta.getBoolean(R.styleable.TwoLevelHeader_srlEnableTwoLevel, this.mEnableTwoLevel);
        this.mEnablePullToCloseTwoLevel = ta.getBoolean(R.styleable.TwoLevelHeader_srlEnablePullToCloseTwoLevel, this.mEnablePullToCloseTwoLevel);
        ta.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        TwoLevelHeader thisGroup = this;
        int len = thisGroup.getChildCount();
        for (int i = 0; i < len; ++i) {
            View childAt = thisGroup.getChildAt(i);
            if (!(childAt instanceof RefreshHeader)) continue;
            this.mRefreshHeader = (RefreshHeader)childAt;
            this.mWrappedInternal = (RefreshInternal)childAt;
            thisGroup.bringChildToFront(childAt);
            break;
        }
        if (this.mRefreshHeader == null) {
            TwoLevelHeader thisView = this;
            this.setRefreshHeader(new ClassicsHeader(thisView.getContext()));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSpinnerStyle = SpinnerStyle.MatchLayout;
        if (this.mRefreshHeader == null) {
            TwoLevelHeader thisView = this;
            this.setRefreshHeader(new ClassicsHeader(thisView.getContext()));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mSpinnerStyle = SpinnerStyle.FixedBehind;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        RefreshHeader refreshHeader = this.mRefreshHeader;
        if (refreshHeader != null) {
            int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            if (mode == Integer.MIN_VALUE) {
                refreshHeader.getView().measure(widthMeasureSpec, heightMeasureSpec);
                int height = refreshHeader.getView().getMeasuredHeight();
                super.setMeasuredDimension(View.resolveSize((int)super.getSuggestedMinimumWidth(), (int)widthMeasureSpec), height);
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    public boolean equals(Object obj) {
        RefreshHeader header = this.mRefreshHeader;
        return header != null && header.equals(obj) || super.equals(obj);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        TwoLevelHeader thisView = this;
        RefreshHeader refreshHeader = this.mRefreshHeader;
        if (refreshHeader == null) {
            return;
        }
        if (1.0f * (float)(maxDragHeight + height) / (float)height != this.mMaxRage && this.mHeaderHeight == 0) {
            this.mHeaderHeight = height;
            this.mRefreshHeader = null;
            kernel.getRefreshLayout().setHeaderMaxDragRate(this.mMaxRage);
            this.mRefreshHeader = refreshHeader;
        }
        if (this.mRefreshKernel == null && refreshHeader.getSpinnerStyle() == SpinnerStyle.Translate && !thisView.isInEditMode()) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)refreshHeader.getView().getLayoutParams();
            params.topMargin -= height;
            refreshHeader.getView().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mHeaderHeight = height;
        this.mRefreshKernel = kernel;
        kernel.requestFloorDuration(this.mFloorDuration);
        kernel.requestNeedTouchEventFor(this, !this.mEnablePullToCloseTwoLevel);
        refreshHeader.onInitialized(kernel, height, maxDragHeight);
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        RefreshHeader refreshHeader = this.mRefreshHeader;
        if (refreshHeader != null) {
            refreshHeader.onStateChanged(refreshLayout, oldState, newState);
            switch (newState) {
                case TwoLevelReleased: {
                    RefreshKernel refreshKernel;
                    if (refreshHeader.getView() != this) {
                        refreshHeader.getView().animate().alpha(0.0f).setDuration((long)(this.mFloorDuration / 2));
                    }
                    if ((refreshKernel = this.mRefreshKernel) == null) break;
                    OnTwoLevelListener twoLevelListener = this.mTwoLevelListener;
                    refreshKernel.startTwoLevel(twoLevelListener == null || twoLevelListener.onTwoLevel(refreshLayout));
                    break;
                }
                case TwoLevel: {
                    break;
                }
                case TwoLevelFinish: {
                    if (refreshHeader.getView() == this) break;
                    refreshHeader.getView().animate().alpha(1.0f).setDuration((long)(this.mFloorDuration / 2));
                    break;
                }
                case PullDownToRefresh: {
                    if (refreshHeader.getView().getAlpha() != 0.0f || refreshHeader.getView() == this) break;
                    refreshHeader.getView().setAlpha(1.0f);
                }
            }
        }
    }

    @Override
    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        this.moveSpinner(offset);
        RefreshHeader refreshHeader = this.mRefreshHeader;
        RefreshKernel refreshKernel = this.mRefreshKernel;
        if (refreshHeader != null) {
            refreshHeader.onMoving(isDragging, percent, offset, height, maxDragHeight);
        }
        if (isDragging) {
            if (this.mPercent < this.mFloorRage && percent >= this.mFloorRage && this.mEnableTwoLevel) {
                refreshKernel.setState(RefreshState.ReleaseToTwoLevel);
            } else if (this.mPercent >= this.mFloorRage && percent < this.mRefreshRage) {
                refreshKernel.setState(RefreshState.PullDownToRefresh);
            } else if (this.mPercent >= this.mFloorRage && percent < this.mFloorRage) {
                refreshKernel.setState(RefreshState.ReleaseToRefresh);
            }
            this.mPercent = percent;
        }
    }

    protected void moveSpinner(int spinner) {
        RefreshHeader refreshHeader = this.mRefreshHeader;
        if (this.mSpinner != spinner && refreshHeader != null) {
            this.mSpinner = spinner;
            switch (refreshHeader.getSpinnerStyle()) {
                case Translate: {
                    refreshHeader.getView().setTranslationY((float)spinner);
                    break;
                }
                case Scale: {
                    View view = refreshHeader.getView();
                    view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getTop() + Math.max(0, spinner));
                    break;
                }
            }
        }
    }

    public TwoLevelHeader setRefreshHeader(RefreshHeader header) {
        return this.setRefreshHeader(header, -1, -2);
    }

    public TwoLevelHeader setRefreshHeader(RefreshHeader header, int width, int height) {
        TwoLevelHeader thisGroup = this;
        if (header != null) {
            RefreshHeader refreshHeader = this.mRefreshHeader;
            if (refreshHeader != null) {
                thisGroup.removeView(refreshHeader.getView());
            }
            if (header.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                thisGroup.addView(header.getView(), 0, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, height));
            } else {
                thisGroup.addView(header.getView(), width, height);
            }
            this.mRefreshHeader = header;
            this.mWrappedInternal = header;
        }
        return this;
    }

    public TwoLevelHeader setMaxRage(float rate) {
        if (this.mMaxRage != rate) {
            this.mMaxRage = rate;
            RefreshKernel refreshKernel = this.mRefreshKernel;
            if (refreshKernel != null) {
                this.mHeaderHeight = 0;
                refreshKernel.getRefreshLayout().setHeaderMaxDragRate(this.mMaxRage);
            }
        }
        return this;
    }

    public TwoLevelHeader setEnablePullToCloseTwoLevel(boolean enabled) {
        RefreshKernel refreshKernel = this.mRefreshKernel;
        this.mEnablePullToCloseTwoLevel = enabled;
        if (refreshKernel != null) {
            refreshKernel.requestNeedTouchEventFor(this, !enabled);
        }
        return this;
    }

    public TwoLevelHeader setFloorRage(float rate) {
        this.mFloorRage = rate;
        return this;
    }

    public TwoLevelHeader setRefreshRage(float rate) {
        this.mRefreshRage = rate;
        return this;
    }

    public TwoLevelHeader setEnableTwoLevel(boolean enabled) {
        this.mEnableTwoLevel = enabled;
        return this;
    }

    public TwoLevelHeader setFloorDuration(int duration) {
        this.mFloorDuration = duration;
        return this;
    }

    public TwoLevelHeader setOnTwoLevelListener(OnTwoLevelListener listener) {
        this.mTwoLevelListener = listener;
        return this;
    }

    public TwoLevelHeader finishTwoLevel() {
        RefreshKernel refreshKernel = this.mRefreshKernel;
        if (refreshKernel != null) {
            refreshKernel.finishTwoLevel();
        }
        return this;
    }
}

