/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.layout.simple;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.scwang.smart.refresh.layout.SmartRefreshLayout;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshFooter;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshKernel;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;

public abstract class SimpleComponent
extends RelativeLayout
implements RefreshComponent {
    protected View mWrappedView;
    protected SpinnerStyle mSpinnerStyle;
    protected RefreshComponent mWrappedInternal;

    protected SimpleComponent(@NonNull View wrapped) {
        this(wrapped, wrapped instanceof RefreshComponent ? (RefreshComponent)wrapped : null);
    }

    protected SimpleComponent(@NonNull View wrappedView, @Nullable RefreshComponent wrappedInternal) {
        super(wrappedView.getContext(), null, 0);
        this.mWrappedView = wrappedView;
        this.mWrappedInternal = wrappedInternal;
        if (this instanceof RefreshFooter && this.mWrappedInternal instanceof RefreshHeader && this.mWrappedInternal.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
            wrappedInternal.getView().setScaleY(-1.0f);
        } else if (this instanceof RefreshHeader && this.mWrappedInternal instanceof RefreshFooter && this.mWrappedInternal.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
            wrappedInternal.getView().setScaleY(-1.0f);
        }
    }

    protected SimpleComponent(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof RefreshComponent) {
                SimpleComponent thisView = this;
                return thisView.getView() == ((RefreshComponent)obj).getView();
            }
            return false;
        }
        return true;
    }

    @Override
    @NonNull
    public View getView() {
        return this.mWrappedView == null ? this : this.mWrappedView;
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            return this.mWrappedInternal.onFinish(refreshLayout, success);
        }
        return 0;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.setPrimaryColors(colors);
        }
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        if (this.mSpinnerStyle != null) {
            return this.mSpinnerStyle;
        }
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            return this.mWrappedInternal.getSpinnerStyle();
        }
        if (this.mWrappedView != null) {
            ViewGroup.LayoutParams params = this.mWrappedView.getLayoutParams();
            if (params instanceof SmartRefreshLayout.LayoutParams) {
                this.mSpinnerStyle = ((SmartRefreshLayout.LayoutParams)params).spinnerStyle;
                if (this.mSpinnerStyle != null) {
                    return this.mSpinnerStyle;
                }
            }
            if (params != null && (params.height == 0 || params.height == -1)) {
                this.mSpinnerStyle = SpinnerStyle.Scale;
                return this.mSpinnerStyle;
            }
        }
        this.mSpinnerStyle = SpinnerStyle.Translate;
        return this.mSpinnerStyle;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        ViewGroup.LayoutParams params;
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.onInitialized(kernel, height, maxDragHeight);
        } else if (this.mWrappedView != null && (params = this.mWrappedView.getLayoutParams()) instanceof SmartRefreshLayout.LayoutParams) {
            kernel.requestDrawBackgroundFor(this, ((SmartRefreshLayout.LayoutParams)params).backgroundColor);
        }
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return this.mWrappedInternal != null && this.mWrappedInternal != this && this.mWrappedInternal.isSupportHorizontalDrag();
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.onHorizontalDrag(percentX, offsetX, offsetMax);
        }
    }

    @Override
    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.onMoving(isDragging, percent, offset, height, maxDragHeight);
        }
    }

    @Override
    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.onReleased(refreshLayout, height, maxDragHeight);
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            this.mWrappedInternal.onStartAnimator(refreshLayout, height, maxDragHeight);
        }
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        if (this.mWrappedInternal != null && this.mWrappedInternal != this) {
            RefreshComponent listener;
            if (this instanceof RefreshFooter && this.mWrappedInternal instanceof RefreshHeader) {
                if (oldState.isFooter) {
                    oldState = oldState.toHeader();
                }
                if (newState.isFooter) {
                    newState = newState.toHeader();
                }
            } else if (this instanceof RefreshHeader && this.mWrappedInternal instanceof RefreshFooter) {
                if (oldState.isHeader) {
                    oldState = oldState.toFooter();
                }
                if (newState.isHeader) {
                    newState = newState.toFooter();
                }
            }
            if ((listener = this.mWrappedInternal) != null) {
                listener.onStateChanged(refreshLayout, oldState, newState);
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public boolean setNoMoreData(boolean noMoreData) {
        return this.mWrappedInternal instanceof RefreshFooter && ((RefreshFooter)this.mWrappedInternal).setNoMoreData(noMoreData);
    }
}

