/*
 * Decompiled with CFR 0.152.
 */
package com.scottyab.rootbeer.util;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class QLog {
    public static final int NONE = 0;
    public static final int ERRORS_ONLY = 1;
    public static final int ERRORS_WARNINGS = 2;
    public static final int ERRORS_WARNINGS_INFO = 3;
    public static final int ERRORS_WARNINGS_INFO_DEBUG = 4;
    public static final int ALL = 5;
    public static int LOGGING_LEVEL = 5;
    private static final String TAG = "RootBeer";
    private static final String TAG_GENERAL_OUTPUT = "QLog";

    public static void e(Object obj, Throwable cause) {
        if (QLog.isELoggable()) {
            Log.e((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.e((String)TAG, (String)QLog.getThrowableTrace(cause));
            Log.e((String)TAG_GENERAL_OUTPUT, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.e((String)TAG_GENERAL_OUTPUT, (String)QLog.getThrowableTrace(cause));
        }
    }

    public static void e(Object obj) {
        if (QLog.isELoggable()) {
            Log.e((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.e((String)TAG_GENERAL_OUTPUT, (String)(QLog.getTrace() + String.valueOf(obj)));
        }
    }

    public static void e(Exception e) {
        if (QLog.isELoggable()) {
            e.printStackTrace();
        }
    }

    public static void w(Object obj, Throwable cause) {
        if (QLog.isWLoggable()) {
            Log.w((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.w((String)TAG, (String)QLog.getThrowableTrace(cause));
            Log.w((String)TAG_GENERAL_OUTPUT, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.w((String)TAG_GENERAL_OUTPUT, (String)QLog.getThrowableTrace(cause));
        }
    }

    public static void w(Object obj) {
        if (QLog.isWLoggable()) {
            Log.w((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
            Log.w((String)TAG_GENERAL_OUTPUT, (String)(QLog.getTrace() + String.valueOf(obj)));
        }
    }

    public static void i(Object obj) {
        if (QLog.isILoggable()) {
            Log.i((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
        }
    }

    public static void d(Object obj) {
        if (QLog.isDLoggable()) {
            Log.d((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
        }
    }

    public static void v(Object obj) {
        if (QLog.isVLoggable()) {
            Log.v((String)TAG, (String)(QLog.getTrace() + String.valueOf(obj)));
        }
    }

    public static boolean isVLoggable() {
        return LOGGING_LEVEL > 4;
    }

    public static boolean isDLoggable() {
        return LOGGING_LEVEL > 3;
    }

    public static boolean isILoggable() {
        return LOGGING_LEVEL > 2;
    }

    public static boolean isWLoggable() {
        return LOGGING_LEVEL > 1;
    }

    public static boolean isELoggable() {
        return LOGGING_LEVEL > 0;
    }

    private static String getThrowableTrace(Throwable thr) {
        StringWriter b = new StringWriter();
        thr.printStackTrace(new PrintWriter(b));
        return b.toString();
    }

    private static String getTrace() {
        int depth = 2;
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        String callerMethodName = elements[depth].getMethodName();
        String callerClassPath = elements[depth].getClassName();
        int lineNo = elements[depth].getLineNumber();
        int i = callerClassPath.lastIndexOf(46);
        String callerClassName = callerClassPath.substring(i + 1);
        return callerClassName + ": " + callerMethodName + "() [" + lineNo + "] - ";
    }

    private QLog() {
    }
}

